"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationClientImpl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _uuid = require("uuid");
var _conversations = require("../../saved_objects/conversations");
var _so_filters = require("../../utils/so_filters");
var _errors = require("../../errors");
var _convert_model = require("./convert_model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ConversationClientImpl {
  constructor({
    client,
    user,
    logger
  }) {
    (0, _defineProperty2.default)(this, "client", void 0);
    (0, _defineProperty2.default)(this, "user", void 0);
    // @ts-expect-error will be used at some point
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.client = client;
    this.user = user;
    this.logger = logger;
  }
  async list(options = {}) {
    const builder = (0, _so_filters.createBuilder)(_conversations.conversationTypeName);
    const filter = builder.and(builder.equals('user_id', this.user.id), ...(options.agentId ? [builder.equals('agent_id', options.agentId)] : [])).toKQL();
    const {
      saved_objects: results
    } = await this.client.find({
      type: _conversations.conversationTypeName,
      filter,
      perPage: 1000
    });
    return results.map(_convert_model.savedObjectToModel);
  }
  async get({
    conversationId
  }) {
    const conversationSo = await this._rawGet({
      conversationId
    });
    return (0, _convert_model.savedObjectToModel)(conversationSo);
  }
  async create(conversation) {
    var _conversation$id;
    const now = new Date();
    const id = (_conversation$id = conversation.id) !== null && _conversation$id !== void 0 ? _conversation$id : (0, _uuid.v4)();
    const attributes = (0, _convert_model.createRequestToRaw)({
      conversation,
      id,
      user: this.user,
      creationDate: now
    });
    const created = await this.client.create(_conversations.conversationTypeName, attributes, {
      id
    });
    return (0, _convert_model.savedObjectToModel)(created);
  }
  async update(conversationId, updatedFields) {
    const conversationSo = await this._rawGet({
      conversationId
    });
    const updatedAttributes = {
      ...conversationSo.attributes,
      ...(0, _convert_model.updateToAttributes)({
        updatedFields
      })
    };
    await this.client.update(_conversations.conversationTypeName, conversationSo.id, updatedAttributes);
    return (0, _convert_model.savedObjectToModel)({
      ...conversationSo,
      attributes: updatedAttributes
    });
  }
  async _rawGet({
    conversationId
  }) {
    const builder = (0, _so_filters.createBuilder)(_conversations.conversationTypeName);
    const filter = builder.and(builder.equals('user_id', this.user.id), builder.equals('conversation_id', conversationId)).toKQL();
    const {
      saved_objects: results
    } = await this.client.find({
      type: _conversations.conversationTypeName,
      filter
    });
    if (results.length > 0) {
      return results[0];
    }
    throw new _errors.WorkchatError(`Conversation ${conversationId} not found`, 404);
  }
}
exports.ConversationClientImpl = ConversationClientImpl;