"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.integrationTypeName = exports.integrationSoType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const integrationTypeName = exports.integrationTypeName = 'workchat_integration';
const integrationSoType = exports.integrationSoType = {
  name: integrationTypeName,
  hidden: true,
  namespaceType: 'agnostic',
  mappings: {
    dynamic: 'strict',
    properties: {
      integration_id: {
        type: 'keyword'
      },
      type: {
        type: 'keyword'
      },
      name: {
        type: 'keyword'
      },
      description: {
        type: 'text'
      },
      configuration: {
        dynamic: false,
        type: 'object',
        properties: {}
      },
      created_at: {
        type: 'date'
      },
      updated_at: {
        type: 'date'
      },
      created_by: {
        type: 'keyword'
      }
    }
  }
};