"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHandlerWrapper = void 0;
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHandlerWrapper = ({
  logger
}) => handler => {
  return (ctx, req, res) => {
    try {
      return handler(ctx, req, res);
    } catch (e) {
      logger.error(e);
      if ((0, _errors.isWorkChatError)(e)) {
        return res.customError({
          body: {
            message: e.message
          },
          statusCode: e.statusCode
        });
      } else {
        throw e;
      }
    }
  };
};
exports.getHandlerWrapper = getHandlerWrapper;