"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkChatAppPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _routes = require("./routes");
var _saved_objects = require("./saved_objects");
var _features = require("./features");
var _integrations = require("./services/integrations");
var _create_services = require("./services/create_services");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class WorkChatAppPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "loggerFactory", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "integrationRegistry", new _integrations.IntegrationRegistry());
    (0, _defineProperty2.default)(this, "services", void 0);
    this.loggerFactory = context.logger;
    _utils.AppLogger.setInstance(this.loggerFactory.get('workchat.app'));
    this.config = context.config.get();
  }
  setup(core, setupDeps) {
    const router = core.http.createRouter();
    (0, _routes.registerRoutes)({
      core,
      router,
      logger: this.loggerFactory.get('routes'),
      getServices: () => {
        if (!this.services) {
          throw new Error('getServices called before #start');
        }
        return this.services;
      }
    });
    (0, _saved_objects.registerTypes)({
      savedObjects: core.savedObjects
    });
    (0, _features.registerFeatures)({
      features: setupDeps.features
    });
    return {
      integrations: {
        register: tool => {
          return this.integrationRegistry.register(tool);
        }
      }
    };
  }
  start(core, pluginsDependencies) {
    this.services = (0, _create_services.createServices)({
      core,
      config: this.config,
      loggerFactory: this.loggerFactory,
      pluginsDependencies,
      integrationRegistry: this.integrationRegistry
    });
    return {};
  }
}
exports.WorkChatAppPlugin = WorkChatAppPlugin;