"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortAndGroupConversations = exports.getDefaultBuckets = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultBuckets = () => {
  return [{
    code: 'TODAY',
    label: _i18n.i18n.translate('xpack.workchatApp.conversationGroups.labels.today', {
      defaultMessage: 'Today'
    }),
    limit: 'now/d'
  }, {
    code: 'YESTERDAY',
    label: _i18n.i18n.translate('xpack.workchatApp.conversationGroups.labels.yesterday', {
      defaultMessage: 'Yesterday'
    }),
    limit: 'now-1d/d'
  }, {
    code: 'LAST_WEEK',
    label: _i18n.i18n.translate('xpack.workchatApp.conversationGroups.labels.lastWeek', {
      defaultMessage: 'Last week'
    }),
    limit: 'now/w'
  }, {
    code: 'LAST_2_WEEKS',
    label: _i18n.i18n.translate('xpack.workchatApp.conversationGroups.labels.lastTwoWeeks', {
      defaultMessage: 'Last 2 weeks'
    }),
    limit: 'now/2w'
  }, {
    code: 'LAST_MONTH',
    label: _i18n.i18n.translate('xpack.workchatApp.conversationGroups.labels.lastMonth', {
      defaultMessage: 'Last month'
    }),
    limit: 'now/m'
  }, {
    code: 'LAST_3_MONTHS',
    label: _i18n.i18n.translate('xpack.workchatApp.conversationGroups.labels.lastThreeMonths', {
      defaultMessage: 'Last 3 months'
    }),
    limit: 'now/3m'
  }, {
    code: 'LAST_6_MONTHS',
    label: _i18n.i18n.translate('xpack.workchatApp.conversationGroups.labels.lastSixMonths', {
      defaultMessage: 'Last 6 months'
    }),
    limit: 'now/6m'
  }, {
    code: 'LAST_YEAR',
    label: _i18n.i18n.translate('xpack.workchatApp.conversationGroups.labels.lastYear', {
      defaultMessage: 'Last month'
    }),
    limit: 'now/y'
  }, {
    code: 'OLDER',
    label: _i18n.i18n.translate('xpack.workchatApp.conversationGroups.labels.before', {
      defaultMessage: 'Before'
    }),
    limit: false
  }];
};

/**
 * Sort and group conversation by time period to display them in the ConversationList component.
 */
exports.getDefaultBuckets = getDefaultBuckets;
const sortAndGroupConversations = (conversations, buckets = getDefaultBuckets(), now = new Date()) => {
  const getEpochLimit = range => {
    var _getAbsoluteTime$valu, _getAbsoluteTime;
    if (range === false) {
      return 0;
    }
    return (_getAbsoluteTime$valu = (_getAbsoluteTime = getAbsoluteTime(range, {
      forceNow: now
    })) === null || _getAbsoluteTime === void 0 ? void 0 : _getAbsoluteTime.valueOf()) !== null && _getAbsoluteTime$valu !== void 0 ? _getAbsoluteTime$valu : 0;
  };
  const groups = buckets.map(({
    label,
    limit
  }) => {
    return emptyGroup(label, getEpochLimit(limit));
  });
  conversations.map(conversation => {
    return {
      conversation,
      date: (0, _moment.default)(conversation.lastUpdated)
    };
  }).sort((conv1, conv2) => {
    return conv2.date.valueOf() - conv1.date.valueOf();
  }).forEach(({
    conversation,
    date
  }) => {
    for (const group of groups) {
      if (date.isAfter(group.dateLimit)) {
        group.conversations.push(conversation);
        break;
      }
    }
  });
  return groups.filter(group => group.conversations.length > 0).map(({
    conversations: convs,
    dateLabel
  }) => ({
    conversations: convs,
    dateLabel
  }));
};
exports.sortAndGroupConversations = sortAndGroupConversations;
const emptyGroup = (label, limit) => ({
  dateLabel: label,
  dateLimit: limit,
  conversations: []
});
const getAbsoluteTime = (range, opts = {}) => {
  const parsed = _datemath.default.parse(range, opts);
  return parsed !== null && parsed !== void 0 && parsed.isValid() ? parsed : undefined;
};