"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkchatAppRoutes = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _home = require("./pages/home");
var _chat = require("./pages/chat");
var _assistants = require("./pages/assistants");
var _assistant_details = require("./pages/assistant_details");
var _integrations = require("./pages/integrations");
var _integration_edit_or_create = require("./pages/integration_edit_or_create");
var _assistant_workflow = require("./pages/assistant_workflow");
var _integrations_catalog = require("./pages/integrations_catalog");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkchatAppRoutes = () => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/assistants/:agentId/chat/:conversationId"
  }, /*#__PURE__*/_react.default.createElement(_chat.WorkchatChatPage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/assistants/:agentId/chat"
  }, /*#__PURE__*/_react.default.createElement(_chat.WorkchatChatPage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/assistants/create",
    strict: true
  }, /*#__PURE__*/_react.default.createElement(_assistant_details.WorkChatAssistantOverviewPage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/assistants/:agentId/edit",
    strict: true
  }, /*#__PURE__*/_react.default.createElement(_assistant_details.WorkChatAssistantOverviewPage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/assistants/:agentId/workflow",
    strict: true
  }, /*#__PURE__*/_react.default.createElement(_assistant_workflow.WorkChatAssistantWorkflowPage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/assistants",
    strict: true
  }, /*#__PURE__*/_react.default.createElement(_assistants.WorkChatAssistantsPage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/tools/create"
  }, /*#__PURE__*/_react.default.createElement(_integration_edit_or_create.WorkChatIntegrationEditOrCreatePage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/tools/catalog"
  }, /*#__PURE__*/_react.default.createElement(_integrations_catalog.WorkChatCatalogPage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/tools/:integrationId"
  }, /*#__PURE__*/_react.default.createElement(_integration_edit_or_create.WorkChatIntegrationEditOrCreatePage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/tools",
    strict: true
  }, /*#__PURE__*/_react.default.createElement(_integrations.WorkChatIntegrationsPage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/"
  }, /*#__PURE__*/_react.default.createElement(_home.WorkChatHomePage, null)));
};
exports.WorkchatAppRoutes = WorkchatAppRoutes;