"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkchatChatPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _chat_view = require("../components/chat/chat_view");
var _use_breadcrumbs = require("../hooks/use_breadcrumbs");
var _use_agent = require("../hooks/use_agent");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const newConversationId = 'new';
const WorkchatChatPage = () => {
  var _agent$name;
  const {
    agentId,
    conversationId: conversationIdFromParams
  } = (0, _reactRouterDom.useParams)();
  const {
    agent
  } = (0, _use_agent.useAgent)({
    agentId
  });
  (0, _use_breadcrumbs.useBreadcrumb)([{
    text: (_agent$name = agent === null || agent === void 0 ? void 0 : agent.name) !== null && _agent$name !== void 0 ? _agent$name : 'Agent'
  }, {
    text: 'Chat'
  }]);
  const conversationId = (0, _react.useMemo)(() => {
    return conversationIdFromParams === newConversationId ? undefined : conversationIdFromParams;
  }, [conversationIdFromParams]);
  return /*#__PURE__*/_react.default.createElement(_chat_view.WorkchatChatView, {
    agentId: agentId,
    conversationId: conversationId
  });
};
exports.WorkchatChatPage = WorkchatChatPage;