"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkChatAssistantsPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_breadcrumbs = require("../hooks/use_breadcrumbs");
var _use_agent_list = require("../hooks/use_agent_list");
var _assistant_list_view = require("../components/assistant/list/assistant_list_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkChatAssistantsPage = () => {
  (0, _use_breadcrumbs.useBreadcrumb)([{
    text: 'Assistants'
  }]);
  const {
    agents
  } = (0, _use_agent_list.useAgentList)();
  return /*#__PURE__*/_react.default.createElement(_assistant_list_view.AssistantListView, {
    agents: agents
  });
};
exports.WorkChatAssistantsPage = WorkChatAssistantsPage;