"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntegrationDelete = void 0;
var _react = require("react");
var _use_workchat_service = require("./use_workchat_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIntegrationDelete = ({
  onDeleteSuccess,
  onDeleteError
} = {}) => {
  const [isDeleting, setIsDeleting] = (0, _react.useState)(false);
  const {
    integrationService
  } = (0, _use_workchat_service.useWorkChatServices)();
  const deleteIntegration = (0, _react.useCallback)(async integrationId => {
    setIsDeleting(true);
    try {
      await integrationService.delete(integrationId);
      if (onDeleteSuccess) {
        onDeleteSuccess();
      }
    } catch (error) {
      if (onDeleteError) {
        onDeleteError(error);
      }
    } finally {
      setIsDeleting(false);
    }
  }, [integrationService, onDeleteSuccess, onDeleteError]);
  return {
    deleteIntegration,
    isDeleting
  };
};
exports.useIntegrationDelete = useIntegrationDelete;