"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCapabilities = void 0;
var _react = require("react");
var _features = require("../../../common/features");
var _has_capability = require("../utils/has_capability");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCapabilities = () => {
  const {
    services: {
      application: {
        capabilities
      }
    }
  } = (0, _use_kibana.useKibana)();
  const caps = (0, _react.useMemo)(() => {
    return Object.entries(_features.uiCapabilities).reduce((map, [key, value]) => {
      map[key] = (0, _has_capability.hasWorkchatCapability)(capabilities, value);
      return map;
    }, {});
  }, [capabilities]);
  return caps;
};
exports.useCapabilities = useCapabilities;