"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgent = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_workchat_service = require("./use_workchat_service");
var _query_keys = require("../query_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAgent = ({
  agentId
}) => {
  const {
    agentService
  } = (0, _use_workchat_service.useWorkChatServices)();
  const {
    data: agent,
    isLoading,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_keys.queryKeys.agents.details(agentId),
    queryFn: async () => {
      return agentService.get(agentId);
    }
  });
  return {
    agent,
    isLoading,
    refetch
  };
};
exports.useAgent = useAgent;