"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationActiveView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _i18n = require("@kbn/i18n");
var _css = require("@emotion/css");
var _use_navigation = require("../../../hooks/use_navigation");
var _app_paths = require("../../../app_paths");
var _utils = require("../utils");
var _use_agent_list = require("../../../hooks/use_agent_list");
var _i18n2 = require("../i18n");
var _integration_list_view = require("./integration_list_view");
var _use_integration_list = require("../../../hooks/use_integration_list");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IntegrationActiveView = () => {
  const {
    agents
  } = (0, _use_agent_list.useAgentList)();
  const {
    integrations,
    isLoading
  } = (0, _use_integration_list.useIntegrationList)();
  const {
    navigateToWorkchatUrl
  } = (0, _use_navigation.useNavigation)();
  const columns = [{
    field: 'icon',
    name: '',
    width: '30px',
    render: (_, item) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: (0, _utils.getIntegrationIcon)(item.type),
      size: "m"
    }))
  }, {
    field: 'name',
    name: _i18n.i18n.translate('workchatApp.integrations.listView.integrationName', {
      defaultMessage: 'Name'
    }),
    sortable: true,
    render: (_, item) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, item.name)
  }, {
    field: 'type',
    name: _i18n.i18n.translate('workchatApp.integrations.listView.integrationType', {
      defaultMessage: 'Type'
    }),
    render: type => (0, _utils.integrationTypeToLabel)(type)
  }, {
    field: 'status',
    name: _i18n.i18n.translate('workchatApp.integrations.listView.integrationStatus', {
      defaultMessage: 'Status'
    }),
    render: () => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "green"
    }, "Healthy")
  }, {
    field: 'used_in',
    name: _i18n.i18n.translate('workchatApp.integrations.listView.integrationsAgents', {
      defaultMessage: 'Used in...'
    }),
    render: () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none"
    }, agents.map(agent => /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      key: agent.id || agent.name,
      size: "s",
      name: agent.name
    })))
  }, {
    name: _i18n.i18n.translate('workchatApp.integrations.listView.actions', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      name: 'Edit',
      description: 'Edit this integration',
      isPrimary: true,
      icon: 'documentEdit',
      type: 'icon',
      onClick: ({
        id
      }) => {
        navigateToWorkchatUrl(_app_paths.appPaths.tools.edit({
          integrationId: id
        }));
      },
      'data-test-subj': 'integrationListTable-edit-btn'
    }]
  }];

  // Pagination and Sorting
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [sortField, setSortField] = (0, _react.useState)('name');
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    }
  };
  const onTableChange = ({
    page,
    sort
  }) => {
    if (page) {
      const {
        index: index,
        size: size
      } = page;
      setPageIndex(index);
      setPageSize(size);
    }
    if (sort) {
      const {
        field: field,
        direction: direction
      } = sort;
      setSortField(field);
      setSortDirection(direction);
    }
  };
  const findIntegrations = (integrationItems, index, size, field, direction) => {
    let pageOfItems;
    if (!index && !size) {
      pageOfItems = integrationItems;
    } else {
      const startIndex = index * size;
      pageOfItems = integrationItems.slice(startIndex, Math.min(startIndex + size, integrationItems.length));
    }
    if (field) {
      pageOfItems = integrationItems.slice(0).sort(_eui.Comparators.property(field, _eui.Comparators.default(direction)));
    } else {
      pageOfItems = integrationItems;
    }
    return {
      pageOfItems,
      totalItemCount: integrationItems.length
    };
  };
  const {
    pageOfItems,
    totalItemCount
  } = findIntegrations(integrations, pageIndex, pageSize, sortField, sortDirection);
  const resultsCount = pageSize === 0 ? /*#__PURE__*/_react.default.createElement("strong", null, "All") : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, pageSize * pageIndex + 1, "-", pageSize * pageIndex + pageSize), ' ', "of ", totalItemCount);

  // Expandable Rows
  const [toggledItem, setToggledItem] = (0, _react.useState)('');
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const toggleDetails = item => {
    if (itemIdToExpandedRowMap[item.id]) {
      setItemIdToExpandedRowMap({});
      setToggledItem('');
    } else {
      setToggledItem(item.id);
      setItemIdToExpandedRowMap({
        [item.id]: /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
          listItems: [{
            title: 'ID',
            description: item.id
          }, {
            title: 'Name',
            description: item.name
          }]
        })
      });
    }
  };
  const columnsWithExpandingRowToggle = [{
    align: 'left',
    width: '40px',
    isExpander: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: "unfold"
    }),
    mobileOptions: {
      header: false
    },
    render: item => {
      const itemIdToExpandedRowMapValues = {
        ...itemIdToExpandedRowMap
      };
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        color: "text",
        onClick: () => toggleDetails(item),
        "aria-label": itemIdToExpandedRowMapValues[item.id] ? 'Collapse' : 'Expand',
        iconType: itemIdToExpandedRowMapValues[item.id] ? 'arrowDown' : 'arrowRight'
      });
    }
  }, ...columns];

  // emotion styling
  const horizontalRuleStyle = (0, _css.css)`
    height: 2px;
  `;
  const loadingStyle = (0, _css.css)`
    height: 300px;
  `;
  const noIntegrationStyle = (0, _css.css)`
    width: 500px;
    height: 500px;
    margin: auto;
  `;
  const plugStyle = (0, _css.css)`
    margin: auto;
    font-size: 50px;
  `;
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    "data-test-subj": "integrationsListPage"
  }, /*#__PURE__*/_react.default.createElement(_integration_list_view.IntegrationListView, {
    tab: 'active'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    className: horizontalRuleStyle
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    className: loadingStyle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl"
  }))) : integrations.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    className: noIntegrationStyle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", {
    role: "img",
    "aria-label": "plug emoji",
    className: plugStyle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xxl",
    type: "plugs"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('workchatApp.integrations.listView.noIntegrationTitle', {
      defaultMessage: "You haven't connected anything"
    })),
    body: _i18n.i18n.translate('workchatApp.integrations.listView.noIntegrationBody', {
      defaultMessage: "Your connected tools will show up here once you've set up a tool. Until then, nothing for me to work with!"
    }),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => {
        navigateToWorkchatUrl(_app_paths.appPaths.tools.catalog);
      },
      color: "primary",
      fill: true
    }, _i18n2.toolLabels.listView.browseToolLabel)
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _i18n.i18n.translate('workchatApp.integrations.listView.pagination', {
    defaultMessage: 'Showing '
  }), resultsCount), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columnsWithExpandingRowToggle,
    items: pageOfItems,
    itemId: "id",
    pagination: {
      pageIndex,
      pageSize,
      totalItemCount,
      pageSizeOptions: [5, 10, 20, 50],
      showPerPageOptions: true
    },
    sorting: sorting,
    onChange: onTableChange
  }), toggledItem && /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), itemIdToExpandedRowMap[toggledItem]))));
};
exports.IntegrationActiveView = IntegrationActiveView;