"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.chatCommonLabels = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const chatCommonLabels = exports.chatCommonLabels = {
  newConversationLabel: _i18n.i18n.translate('workchatApp.chat.conversations.newConversationLabel', {
    defaultMessage: 'New conversation'
  }),
  userInputBox: {
    placeholder: _i18n.i18n.translate('xpack.workchatApp.chatInputForm.placeholder', {
      defaultMessage: 'Ask anything'
    })
  },
  assistant: {
    defaultNameLabel: _i18n.i18n.translate('xpack.workchatApp.assistant.defaultNameLabel', {
      defaultMessage: 'Assistant'
    })
  },
  assistantStatus: {
    healthy: _i18n.i18n.translate('workchatApp.chat.assistantStatus.healthy', {
      defaultMessage: 'Healthy'
    })
  }
};