"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationGroup = void 0;
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fullHeightClassName = (0, _css.css)`
  height: 100%;
`;
const groupLabelClassName = (0, _css.css)`
  text-transform: uppercase;
`;
const ConversationGroup = ({
  conversations,
  dateLabel,
  activeConversationId,
  onConversationClick
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const listItemClassName = (0, _css.css)`
    font-size: calc(${(0, _eui.useEuiFontSize)('s').fontSize} - 1px);
    font-weight: ${euiTheme.font.weight.regular};
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    color: "transparent",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: groupLabelClassName
  }, /*#__PURE__*/_react.default.createElement("h4", null, dateLabel))), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: false,
    gutterSize: "none",
    className: fullHeightClassName
  }, conversations.map(conversation => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    key: conversation.id,
    color: "text",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      className: listItemClassName
    }, conversation.title),
    onClick: event => onConversationClick(event, conversation.id),
    size: "s",
    isActive: conversation.id === activeConversationId,
    showToolTip: true
  }))));
};
exports.ConversationGroup = ConversationGroup;