"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkchatChatView = void 0;
var _css = require("@emotion/css");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _use_current_user = require("../../hooks/use_current_user");
var _use_conversation_list = require("../../hooks/use_conversation_list");
var _use_navigation = require("../../hooks/use_navigation");
var _app_paths = require("../../app_paths");
var _conversation_panel = require("./conversations_panel/conversation_panel");
var _chat_header = require("./header_bar/chat_header");
var _chat = require("./chat");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkchatChatView = ({
  agentId,
  conversationId
}) => {
  const {
    navigateToWorkchatUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const pageSectionContentClassName = (0, _css.css)`
    width: 100%;
    display: flex;
    flex-grow: 1;
    padding-top: 0;
    padding-bottom: 0;
    height: 100%;
    max-block-size: calc(100vh - var(--kbnAppHeadersOffset, var(--euiFixedHeadersOffset, 0)));
    background-color: ${euiTheme.colors.backgroundBasePlain};
  `;
  const currentUser = (0, _use_current_user.useCurrentUser)();
  const {
    conversations,
    refresh: refreshConversations
  } = (0, _use_conversation_list.useConversationList)({
    agentId
  });
  const onConversationUpdate = (0, _react.useCallback)(changes => {
    if (!conversationId) {
      navigateToWorkchatUrl(_app_paths.appPaths.chat.conversation({
        agentId,
        conversationId: changes.id
      }));
    }
    refreshConversations();
  }, [agentId, conversationId, refreshConversations, navigateToWorkchatUrl]);
  const [connectorId, setConnectorId] = (0, _react.useState)();
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    offset: 0,
    restrictWidth: false,
    "data-test-subj": "workchatPageChat",
    grow: false,
    panelled: false
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Sidebar, {
    paddingSize: "none",
    minWidth: 280
  }, /*#__PURE__*/_react.default.createElement(_conversation_panel.ConversationPanel, {
    agentId: agentId,
    conversations: conversations,
    activeConversationId: conversationId,
    onConversationSelect: newConvId => {
      navigateToWorkchatUrl(_app_paths.appPaths.chat.conversation({
        agentId,
        conversationId: newConvId
      }));
    },
    onNewConversationSelect: () => {
      navigateToWorkchatUrl(_app_paths.appPaths.chat.new({
        agentId
      }));
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    paddingSize: "none",
    grow: true,
    contentProps: {
      css: 'height: 100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: pageSectionContentClassName,
    direction: "column",
    gutterSize: "none",
    justifyContent: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_chat_header.ChatHeader, {
    connectorId: connectorId,
    conversationId: conversationId,
    onConnectorChange: setConnectorId
  }), /*#__PURE__*/_react.default.createElement(_chat.Chat, {
    agentId: agentId,
    conversationId: conversationId,
    connectorId: connectorId,
    currentUser: currentUser,
    onConversationUpdate: onConversationUpdate
  }))));
};
exports.WorkchatChatView = WorkchatChatView;