"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatInputForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _i18n = require("./i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChatInputForm = ({
  disabled,
  loading,
  onSubmit
}) => {
  const [message, setMessage] = (0, _react.useState)('');
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const handleSubmit = (0, _react.useCallback)(() => {
    if (loading || !message.trim()) {
      return;
    }
    onSubmit(message);
    setMessage('');
  }, [message, loading, onSubmit]);
  const handleChange = (0, _react.useCallback)(event => {
    setMessage(event.currentTarget.value);
  }, []);
  const handleTextAreaKeyDown = (0, _react.useCallback)(event => {
    if (!event.shiftKey && event.key === _eui.keys.ENTER) {
      event.preventDefault();
      handleSubmit();
    }
  }, [handleSubmit]);
  const topContainerClass = (0, _css.css)`
    padding-bottom: ${euiTheme.size.m};
  `;
  const inputFlexItemClass = (0, _css.css)`
    max-width: 900px;
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center",
    justifyContent: "center",
    className: topContainerClass
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: inputFlexItemClass
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    "data-test-subj": "workchatAppChatInputFormTextArea",
    fullWidth: true,
    rows: 1,
    value: message,
    onChange: handleChange,
    onKeyDown: handleTextAreaKeyDown,
    placeholder: _i18n.chatCommonLabels.userInputBox.placeholder
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "workchatAppChatInputFormSubmitButton",
    iconType: "kqlFunction",
    display: "fill",
    size: "m",
    onClick: handleSubmit,
    disabled: loading || disabled,
    isLoading: loading
  })));
};
exports.ChatInputForm = ChatInputForm;