"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssistantWorkflow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _use_navigation = require("../../../hooks/use_navigation");
var _i18n = require("../i18n");
var _app_paths = require("../../../app_paths");
var _use_breadcrumbs = require("../../../hooks/use_breadcrumbs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssistantWorkflow = ({
  agentId
}) => {
  const {
    createWorkchatUrl
  } = (0, _use_navigation.useNavigation)();
  const breadcrumb = (0, _react.useMemo)(() => {
    return [{
      text: _i18n.assistantLabels.breadcrumb.assistantsPill,
      href: createWorkchatUrl(_app_paths.appPaths.assistants.list)
    }, {
      text: _i18n.assistantLabels.breadcrumb.assistantWorkflowPill
    }];
  }, [createWorkchatUrl]);
  (0, _use_breadcrumbs.useBreadcrumb)(breadcrumb);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    paddingSize: "m"
  }, "todo...");
};
exports.AssistantWorkflow = AssistantWorkflow;