"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiCapabilities = exports.capabilityGroups = exports.apiCapabilities = exports.WORKCHAT_FEATURE_NAME = exports.WORKCHAT_FEATURE_ID = exports.WORKCHAT_APP_ID = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WORKCHAT_FEATURE_ID = exports.WORKCHAT_FEATURE_ID = 'workchat';
const WORKCHAT_FEATURE_NAME = exports.WORKCHAT_FEATURE_NAME = 'WorkChat';
const WORKCHAT_APP_ID = exports.WORKCHAT_APP_ID = 'workchat';
const uiCapabilities = exports.uiCapabilities = {
  show: 'show',
  showManagement: 'showManagement'
};
const apiCapabilities = exports.apiCapabilities = {
  useWorkchat: 'workchat_use',
  manageWorkchat: 'workchat_manage'
};

// defining feature groups here because it's less error prone when adding new capabilities
const capabilityGroups = exports.capabilityGroups = {
  ui: {
    read: [uiCapabilities.show],
    all: [uiCapabilities.show, uiCapabilities.showManagement]
  },
  api: {
    read: [apiCapabilities.useWorkchat],
    all: [apiCapabilities.useWorkchat, apiCapabilities.manageWorkchat]
  }
};