"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toolResultEvent = exports.messageEvent = exports.isToolResultEvent = exports.isMessageEvent = exports.isConversationUpdatedEvent = exports.isConversationCreatedEvent = exports.isChunkEvent = exports.conversationUpdatedEvent = exports.conversationCreatedEvent = exports.chunkEvent = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Emitted when a message chunk is emitted by the LLM.
 */

/**
 * Emitted when a conversation was created.
 *
 * Can be used to update the UI with the new information.
 */

/**
 * Emitted when a conversation was updated.
 *
 * Can be used to update the UI with the new information.
 */

/**
 * Emitted when a full message was generated.
 */

const conversationCreatedEvent = ({
  id,
  title
}) => {
  return {
    type: 'conversation_created',
    conversation: {
      id,
      title
    }
  };
};
exports.conversationCreatedEvent = conversationCreatedEvent;
const conversationUpdatedEvent = ({
  id,
  title
}) => {
  return {
    type: 'conversation_updated',
    conversation: {
      id,
      title
    }
  };
};

/**
 * Creates a chunk event to represent partial content from an LLM response.
 */
exports.conversationUpdatedEvent = conversationUpdatedEvent;
const chunkEvent = ({
  contentChunk,
  messageId
}) => {
  return {
    type: 'message_chunk',
    content_chunk: contentChunk,
    message_id: messageId
  };
};

/**
 * Creates a message event to represent a complete message from either a user or assistant.
 */
exports.chunkEvent = chunkEvent;
const messageEvent = ({
  message
}) => {
  return {
    type: 'message',
    message
  };
};

/**
 * Creates a tool result event to represent the result of a tool execution.
 */
exports.messageEvent = messageEvent;
const toolResultEvent = ({
  callId,
  result
}) => {
  return {
    type: 'tool_result',
    toolResult: {
      callId,
      result
    }
  };
};
exports.toolResultEvent = toolResultEvent;
const isMessageEvent = event => {
  return event.type === 'message';
};
exports.isMessageEvent = isMessageEvent;
const isChunkEvent = event => {
  return event.type === 'message_chunk';
};
exports.isChunkEvent = isChunkEvent;
const isToolResultEvent = event => {
  return event.type === 'tool_result';
};
exports.isToolResultEvent = isToolResultEvent;
const isConversationCreatedEvent = event => {
  return event.type === 'conversation_created';
};
exports.isConversationCreatedEvent = isConversationCreatedEvent;
const isConversationUpdatedEvent = event => {
  return event.type === 'conversation_updated';
};
exports.isConversationUpdatedEvent = isConversationUpdatedEvent;