"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMcpServer = void 0;
var _mcp = require("@modelcontextprotocol/sdk/server/mcp.js");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createMcpServer = ({
  name,
  version = '1.0.0',
  tools
}) => {
  const server = new _mcp.McpServer({
    name,
    version
  });
  tools.forEach(tool => {
    server.tool(tool.name, tool.description, tool.schema, async params => {
      return tool.execute(params);
    });
  });
  return server;
};
exports.createMcpServer = createMcpServer;