"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMcpServer = createMcpServer;
var _wcIntegrationUtils = require("@kbn/wc-integration-utils");
var _wciCommon = require("@kbn/wci-common");
var _wciServer = require("@kbn/wci-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: fix this

async function createMcpServer(options) {
  const searchTool = await createSearchTool(options);
  return (0, _wciServer.createMcpServer)({
    name: 'wci-index-source',
    version: '1.0.0',
    tools: [searchTool]
  });
}
const createSearchTool = async ({
  integrationId,
  configuration,
  description,
  elasticsearchClient,
  logger
}) => {
  const {
    index,
    fields
  } = configuration;
  const searchFilters = fields.filterFields.map(field => ({
    field: field.field,
    description: field.description,
    values: [],
    // filters are only a subset of field types
    type: field.type
  }));
  const aggFields = fields.filterFields.filter(field => field.getValues).map(field => field.field);
  if (aggFields.length > 0) {
    const topValues = await (0, _wcIntegrationUtils.getFieldsTopValues)({
      indexName: index,
      fieldNames: aggFields.map(field => field),
      esClient: elasticsearchClient
    });
    searchFilters.forEach(fieldValue => {
      fieldValue.values = topValues[fieldValue.field];
    });
  }
  const toolSchema = (0, _wcIntegrationUtils.generateSearchSchema)({
    filters: searchFilters
  });
  const searchTool = {
    name: 'search',
    description,
    schema: toolSchema,
    execute: async ({
      query,
      ...filterValues
    }) => {
      logger.debug(() => `Searching for "${query}" in index "${index}" with filters: ${JSON.stringify(filterValues)}"`);
      let result = null;
      const esFilters = (0, _wcIntegrationUtils.createFilterClauses)({
        filters: searchFilters,
        values: filterValues
      });
      const contentFields = fields.contextFields.map(field => field.field);
      try {
        const queryClause = query && configuration.queryTemplate ? JSON.parse(configuration.queryTemplate.replace('{query}', query)) : {
          match_all: {}
        };
        result = await elasticsearchClient.search({
          index,
          query: {
            bool: {
              must: [queryClause],
              ...(esFilters.length > 0 ? {
                filter: esFilters
              } : {})
            }
          },
          _source: {
            includes: contentFields
          },
          highlight: {
            fields: fields.contextFields.reduce((acc, field) => {
              if (field.type === 'semantic') {
                acc[field.field] = {
                  type: 'semantic'
                };
              }
              return acc;
            }, {})
          }
        });
      } catch (error) {
        logger.error(`Failed to search: ${error}`);
      }
      if (!result) {
        return {
          content: []
        };
      }
      logger.debug(`Found ${result.hits.hits.length} hits`);
      const createRef = (0, _wciCommon.contentRefBuilder)({
        sourceType: _wciCommon.ContentRefSourceType.integration,
        sourceId: integrationId
      });
      const documents = result.hits.hits.map(hit => {
        return {
          reference: createRef(hit._id),
          content: (0, _wcIntegrationUtils.hitToContent)({
            hit,
            fields: contentFields
          })
        };
      });
      return _wciServer.toolResultFactory.contentList(documents);
    }
  };
  return searchTool;
};