"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGenerateSchema = void 0;
var _reactQuery = require("@kbn/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGenerateSchema = () => {
  const {
    services: {
      http,
      notifications
    }
  } = (0, _public.useKibana)();
  const {
    mutate,
    isLoading
  } = (0, _reactQuery.useMutation)({
    mutationFn: async ({
      indexName
    }) => {
      const response = await http.post('/internal/wci-index-source/configuration/generate', {
        body: JSON.stringify({
          indexName
        })
      });
      return response.definition;
    },
    onError: err => {
      notifications.toasts.addError(err, {
        title: 'Error generating schema'
      });
    }
  });
  return {
    isLoading,
    generateSchema: mutate
  };
};
exports.useGenerateSchema = useGenerateSchema;