"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExternalServerIntegrationDefinition = void 0;
var _wciCommon = require("@kbn/wci-common");
var _wciServer = require("@kbn/wci-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getExternalServerIntegrationDefinition = ({
  core,
  logger
}) => {
  return {
    getType: () => _wciCommon.IntegrationType.external_server,
    createIntegration: async ({
      configuration
    }) => {
      return {
        connect: (0, _wciServer.getConnectToExternalServer)({
          serverUrl: configuration.url
        })
      };
    }
  };
};
exports.getExternalServerIntegrationDefinition = getExternalServerIntegrationDefinition;