"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFilterClauses = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createFilterClauses = ({
  filters,
  values
}) => {
  const clauses = [];
  Object.entries(values).forEach(([field, value]) => {
    const filter = filters.find(f => f.field === field);
    if (filter) {
      if (filter.type === 'keyword' || filter.type === 'boolean') {
        clauses.push({
          term: {
            [field]: value
          }
        });
      }
      // TODO: handle other field types, date mostly
    }
  });
  return clauses;
};
exports.createFilterClauses = createFilterClauses;