"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldTypeByPath = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Resolves the type of a given field from its path in the provided mappings.
 */
const getFieldTypeByPath = ({
  fieldPath,
  mappings
}) => {
  var _mappings$properties;
  let properties = (_mappings$properties = mappings.properties) !== null && _mappings$properties !== void 0 ? _mappings$properties : {};
  const paths = fieldPath.split('.');
  for (let i = 0; i < paths.length; i++) {
    const path = paths[i];
    const isLast = i === paths.length - 1;
    if (isLast) {
      var _properties$path;
      if ((_properties$path = properties[path]) !== null && _properties$path !== void 0 && _properties$path.type) {
        var _properties$path2;
        return (_properties$path2 = properties[path]) === null || _properties$path2 === void 0 ? void 0 : _properties$path2.type;
      } else {
        throw Error(`Field '${fieldPath}' not found in mappings`);
      }
    } else {
      var _properties$path3;
      if ((_properties$path3 = properties[path]) !== null && _properties$path3 !== void 0 && _properties$path3.properties) {
        properties = properties[path].properties;
      } else {
        throw Error(`Field '${fieldPath}' not found in mappings`);
      }
    }
  }
  throw Error(`Exited loop without return (should never happen)`);
};
exports.getFieldTypeByPath = getFieldTypeByPath;