"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSampleDocuments = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSampleDocuments = async ({
  indexName,
  esClient,
  maxSamples = 5
}) => {
  const response = await esClient.search({
    index: indexName,
    size: maxSamples
  });
  const documents = response.hits.hits.map(hit => hit._source);
  return {
    samples: documents
  };
};
exports.getSampleDocuments = getSampleDocuments;