"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isWorkflowProgressionEvent = exports.isNodeProgressionEvent = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Workflow progression event.
 *
 * Can be emitted to do real time status update during a workflow execution.
 */

/**
 * Represent all type of events that can be fired during a workflow run
 */

/**
 * Checks if the given workflow run event is a {@link NodeProgressionEvent}
 */
const isNodeProgressionEvent = event => {
  return event.eventType === 'node_progression';
};

/**
 * Checks if the given workflow run event is a {@link WorkflowProgressionEvent}
 */
exports.isNodeProgressionEvent = isNodeProgressionEvent;
const isWorkflowProgressionEvent = event => {
  return event.eventType === 'workflow_progression';
};
exports.isWorkflowProgressionEvent = isWorkflowProgressionEvent;