"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveToLibrary = void 0;
var _services = require("../services");
var _saved_visualize_utils = require("../utils/saved_visualize_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const saveToLibrary = async ({
  uiState,
  rawState,
  references
}) => {
  const {
    savedVis: serializedVis,
    title,
    description,
    getDisplayName,
    getEsType,
    managed
  } = rawState;
  const visSavedObjectAttributes = {
    title,
    description,
    visState: {
      type: serializedVis.type,
      params: serializedVis.params,
      aggs: serializedVis.data.aggs,
      title: serializedVis.title
    },
    savedSearchId: serializedVis.data.savedSearchId,
    ...(serializedVis.data.savedSearchRefName ? {
      savedSearchRefName: String(serializedVis.data.savedSearchRefName)
    } : {}),
    searchSourceFields: serializedVis.data.searchSource,
    uiStateJSON: uiState.toString(),
    lastSavedTitle: '',
    displayName: title,
    getDisplayName,
    getEsType,
    managed
  };
  const libraryId = await (0, _saved_visualize_utils.saveVisualization)(visSavedObjectAttributes, {
    confirmOverwrite: false
  }, {
    analytics: (0, _services.getAnalytics)(),
    i18n: (0, _services.getI18n)(),
    overlays: (0, _services.getOverlays)(),
    theme: (0, _services.getTheme)(),
    userProfile: (0, _services.getUserProfile)()
  }, references !== null && references !== void 0 ? references : []);
  return libraryId;
};
exports.saveToLibrary = saveToLibrary;