"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createVegaRequestHandler = createVegaRequestHandler;
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/data-plugin/public");
var _search_api = require("./data_model/search_api");
var _time_cache = require("./data_model/time_cache");
var _services = require("./services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function createVegaRequestHandler({
  plugins: {
    data
  },
  core: {
    uiSettings,
    theme
  },
  getServiceSettings
}, context = {}) {
  let searchAPI;
  const {
    timefilter
  } = data.query.timefilter;
  const timeCache = new _time_cache.TimeCache(timefilter, 3 * 1000);
  return async function vegaRequestHandler({
    timeRange,
    filters,
    query,
    visParams,
    searchSessionId,
    executionContext
  }) {
    var _filters$;
    const {
      search
    } = (0, _services.getData)();
    const dataViews = (0, _services.getDataViews)();
    if (!searchAPI) {
      searchAPI = new _search_api.SearchAPI({
        uiSettings,
        search,
        indexPatterns: dataViews
      }, context.abortSignal, context.inspectorAdapters, searchSessionId, executionContext);
    }
    timeCache.setTimeRange(timeRange);
    let dataView;
    const firstFilterIndex = (_filters$ = filters[0]) === null || _filters$ === void 0 ? void 0 : _filters$.meta.index;
    if (firstFilterIndex) {
      dataView = await dataViews.get(firstFilterIndex).catch(() => undefined);
    }
    const esQueryConfigs = (0, _public.getEsQueryConfig)(uiSettings);
    const filtersDsl = (0, _esQuery.buildEsQuery)(dataView, query, filters, esQueryConfigs);
    const {
      VegaParser
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
    const vp = new VegaParser(visParams.spec, searchAPI, timeCache, filtersDsl, getServiceSettings, theme.getTheme());
    return await vp.parseAsync();
  };
}