"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiValueRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var _add_delete_buttons = require("../../add_delete_buttons");
var _color_picker = require("../../color_picker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const MultiValueRow = ({
  model,
  onChange,
  onDelete,
  onAdd,
  disableAdd,
  disableDelete,
  enableColorPicker
}) => {
  const onFieldNumberChange = event => onChange({
    ...model,
    value: (0, _lodash.get)(event, 'target.value')
  });
  const onColorPickerChange = props => onChange({
    ...model,
    color: (props === null || props === void 0 ? void 0 : props.color) || _constants.TSVB_DEFAULT_COLOR
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    className: "tvbAggRow__multiValueRow"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, enableColorPicker && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_color_picker.ColorPicker, {
    disableTrash: true,
    onChange: onColorPickerChange,
    value: model.color,
    name: "color"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: model.value === '' ? '' : Number(model.value),
    placeholder: "0",
    onChange: onFieldNumberChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_delete_buttons.AddDeleteButtons, {
    onAdd: onAdd,
    onDelete: () => onDelete(model),
    disableDelete: disableDelete,
    disableAdd: disableAdd,
    responsive: false
  }))));
};
exports.MultiValueRow = MultiValueRow;
MultiValueRow.defaultProps = {
  model: {
    id: null,
    value: ''
  }
};