"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DerivativeAgg = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _agg_select = require("./agg_select");
var _metric_select = require("./metric_select");
var _agg_row = require("./agg_row");
var _create_change_handler = require("../lib/create_change_handler");
var _create_select_handler = require("../lib/create_select_handler");
var _create_text_handler = require("../lib/create_text_handler");
var _enums = require("../../../../common/enums");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _index_patterns_utils = require("../../../../common/index_patterns_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DerivativeAgg = props => {
  const {
    siblings,
    fields,
    indexPattern
  } = props;
  const defaults = {
    unit: ''
  };
  const model = {
    ...defaults,
    ...props.model
  };
  const handleChange = (0, _create_change_handler.createChangeHandler)(props.onChange, model);
  const handleSelectChange = (0, _create_select_handler.createSelectHandler)(handleChange);
  const handleTextChange = (0, _create_text_handler.createTextHandler)(handleChange);
  const htmlId = (0, _eui.htmlIdGenerator)();
  return /*#__PURE__*/_react.default.createElement(_agg_row.AggRow, {
    disableDelete: props.disableDelete,
    model: props.model,
    onAdd: props.onAdd,
    onDelete: props.onDelete,
    siblings: props.siblings,
    dragHandleProps: props.dragHandleProps
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: htmlId('aggregation')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.derivative.aggregationLabel",
    defaultMessage: "Aggregation"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_agg_select.AggSelect, {
    id: htmlId('aggregation'),
    panelType: props.panel.type,
    siblings: props.siblings,
    value: model.type,
    onChange: handleSelectChange('type'),
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('metric'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.derivative.metricLabel",
      defaultMessage: "Metric"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_metric_select.MetricSelect, {
    onChange: handleSelectChange('field'),
    metrics: siblings,
    metric: model,
    fields: fields[(0, _index_patterns_utils.getIndexPatternKey)(indexPattern)],
    value: model.field,
    exclude: [_enums.TSVB_METRIC_TYPES.TOP_HIT],
    fullWidth: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('units'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.derivative.unitsLabel",
      defaultMessage: "Units (1s, 1m, etc)",
      description: "1s and 1m are required values and must not be translated."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    onChange: handleTextChange('unit'),
    value: model.unit,
    fullWidth: true
  })))));
};
exports.DerivativeAgg = DerivativeAgg;
DerivativeAgg.propTypes = {
  disableDelete: _propTypes.default.bool,
  fields: _propTypes.default.object,
  indexPattern: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.object]),
  model: _propTypes.default.object,
  onAdd: _propTypes.default.func,
  onChange: _propTypes.default.func,
  onDelete: _propTypes.default.func,
  panel: _propTypes.default.object,
  series: _propTypes.default.object,
  siblings: _propTypes.default.array
};