"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfiguration = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
var RowHeightMode = /*#__PURE__*/function (RowHeightMode) {
  RowHeightMode["auto"] = "auto";
  RowHeightMode["custom"] = "custom";
  return RowHeightMode;
}(RowHeightMode || {});
const getColumns = (params, metrics, columns, bucketCollapseFn) => {
  const {
    showTotal,
    totalFunc
  } = params;
  return columns.map(({
    columnId
  }) => {
    const collapseFn = bucketCollapseFn ? Object.keys(bucketCollapseFn).find(key => bucketCollapseFn[key].includes(columnId)) : undefined;
    return {
      columnId,
      alignment: 'left',
      ...(showTotal && metrics.includes(columnId) ? {
        summaryRow: totalFunc
      } : {}),
      ...(collapseFn ? {
        collapseFn
      } : {})
    };
  });
};
const getPagination = ({
  perPage
}) => {
  return {
    enabled: perPage !== '',
    size: perPage !== '' ? perPage : 0
  };
};
const getRowHeight = params => {
  const {
    autoFitRowToContent
  } = params;
  return {
    rowHeight: autoFitRowToContent ? RowHeightMode.auto : RowHeightMode.custom,
    headerRowHeight: autoFitRowToContent ? RowHeightMode.auto : RowHeightMode.custom
  };
};
const getConfiguration = (layerId, params, {
  metrics,
  buckets,
  columnsWithoutReferenced,
  bucketCollapseFn
}) => {
  return {
    layerId,
    layerType: 'data',
    columns: getColumns(params, metrics, columnsWithoutReferenced, bucketCollapseFn),
    paging: getPagination(params),
    ...getRowHeight(params)
  };
};
exports.getConfiguration = getConfiguration;