"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMetricVisTypeDefinition = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/charts-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _components = require("./components");
var _to_ast = require("./to_ast");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const createMetricVisTypeDefinition = () => ({
  name: 'metric',
  title: _i18n.i18n.translate('visTypeMetric.metricTitle', {
    defaultMessage: 'Metric'
  }),
  icon: 'visMetric',
  description: _i18n.i18n.translate('visTypeMetric.metricDescription', {
    defaultMessage: 'Show a calculation as a single number.'
  }),
  fetchDatatable: true,
  toExpressionAst: _to_ast.toExpressionAst,
  visConfig: {
    defaults: {
      addTooltip: true,
      addLegend: false,
      type: 'metric',
      metric: {
        percentageMode: false,
        useRanges: false,
        colorSchema: _public.ColorSchemas.GreenToRed,
        metricColorMode: _public.ColorMode.None,
        colorsRange: [{
          from: 0,
          to: 10000
        }],
        labels: {
          show: true
        },
        invertColors: false,
        style: {
          bgFill: '#000',
          bgColor: false,
          labelColor: false,
          subText: '',
          fontSize: 60
        }
      }
    }
  },
  editorConfig: {
    enableDataViewChange: true,
    optionsTemplate: _components.MetricVisOptions,
    schemas: [{
      group: _public2.AggGroupNames.Metrics,
      name: 'metric',
      title: _i18n.i18n.translate('visTypeMetric.schemas.metricTitle', {
        defaultMessage: 'Metric'
      }),
      min: 1,
      aggFilter: ['!std_dev', '!geo_centroid', '!derivative', '!serial_diff', '!moving_avg', '!cumulative_sum', '!geo_bounds', '!filtered_metric', '!single_percentile', '!single_percentile_rank'],
      aggSettings: {
        top_hits: {
          allowStrings: true
        }
      },
      defaults: [{
        type: 'count',
        schema: 'metric'
      }]
    }, {
      group: _public2.AggGroupNames.Buckets,
      name: 'group',
      title: _i18n.i18n.translate('visTypeMetric.schemas.splitGroupTitle', {
        defaultMessage: 'Split group'
      }),
      min: 0,
      max: 1,
      aggFilter: ['!geotile_grid', '!filter', '!sampler', '!diversified_sampler', '!rare_terms', '!multi_terms', '!significant_text']
    }]
  },
  requiresSearch: true,
  navigateToLens: async (vis, timefilter) => {
    const {
      convertToLens
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./convert_to_lens')));
    return vis ? convertToLens(vis, timefilter) : null;
  },
  getExpressionVariables: async (vis, timeFilter) => {
    const {
      convertToLens
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./convert_to_lens')));
    return {
      canNavigateToLens: Boolean(vis !== null && vis !== void 0 && vis.params ? await convertToLens(vis, timeFilter) : null)
    };
  }
});
exports.createMetricVisTypeDefinition = createMetricVisTypeDefinition;