"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddedMap = void 0;
exports.EmbeddedMapComponent = EmbeddedMapComponent;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _use_layer_list = require("./use_layer_list");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _map_tooltip = require("./map_tooltip");
var _use_map_filters = require("./use_map_filters");
var _use_kibana_services = require("../../../../hooks/use_kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmbeddedPanel = _styled.default.div`
  z-index: auto;
  flex: 1;
  display: flex;
  flex-direction: column;
  height: 100%;
  position: relative;
  .embPanel__content {
    display: flex;
    flex: 1 1 100%;
    z-index: 1;
    min-height: 0; // Absolute must for Firefox to scroll contents
  }
  &&& .maplibregl-canvas {
    animation: none !important;
  }
`;
function EmbeddedMapComponent() {
  const {
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    start,
    end,
    serviceName
  } = urlParams;
  const mapFilters = (0, _use_map_filters.useMapFilters)();
  const layerList = (0, _use_layer_list.useLayerList)();
  const {
    maps
  } = (0, _use_kibana_services.useKibanaServices)();
  function renderTooltipContent({
    addFilters,
    closeTooltip,
    features,
    isLocked,
    getLayerName,
    loadFeatureProperties
  }) {
    const props = {
      addFilters,
      closeTooltip,
      isLocked,
      getLayerName,
      loadFeatureProperties
    };
    return /*#__PURE__*/_react.default.createElement(_map_tooltip.MapToolTip, (0, _extends2.default)({}, props, {
      features: features
    }));
  }
  return /*#__PURE__*/_react.default.createElement(EmbeddedPanel, null, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "xpack.ux.regionMap.embeddedPanel",
    className: "embPanel__content"
  }, serviceName && maps && maps.Map({
    title: 'Visitors by region',
    filters: mapFilters,
    isLayerTOCOpen: false,
    query: {
      query: 'transaction.type : "page-load"',
      language: 'kuery'
    },
    ...(start && {
      timeRange: {
        from: new Date(start).toISOString(),
        to: new Date(end).toISOString()
      }
    }),
    hideFilterActions: true,
    layerList,
    getTooltipRenderer: () => renderTooltipContent
  })));
}
EmbeddedMapComponent.displayName = 'EmbeddedMap';
const EmbeddedMap = exports.EmbeddedMap = /*#__PURE__*/_react.default.memo(EmbeddedMapComponent);