"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchMonitorDetailsEffect = fetchMonitorDetailsEffect;
var _effects = require("redux-saga/effects");
var _monitor = require("../actions/monitor");
var _api = require("../api");
var _fetch_effect = require("./fetch_effect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* fetchMonitorDetailsEffect() {
  yield (0, _effects.takeLatest)(_monitor.getMonitorDetailsAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.fetchMonitorDetails, _monitor.getMonitorDetailsAction.success, _monitor.getMonitorDetailsAction.fail));
  yield (0, _effects.takeLatest)(_monitor.getMonitorLocationsAction, (0, _fetch_effect.fetchEffectFactory)(_api.fetchMonitorLocations, _monitor.getMonitorLocationsActionSuccess, _monitor.getMonitorLocationsActionFail));
}