"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IntegrationLink = ({
  ariaLabel,
  href,
  iconType,
  message,
  tooltipContent
}) => typeof href === 'undefined' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: _i18n.i18n.translate('xpack.uptime.integrationLink.missingDataMessage', {
    defaultMessage: 'Required data for this integration was not found.'
  }),
  type: iconType
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "subdued"
}, message))) : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  "data-test-subj": "syntheticsIntegrationLinkLink",
  "aria-label": ariaLabel,
  href: href
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: tooltipContent,
  position: "top",
  type: iconType
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, message)));
exports.IntegrationLink = IntegrationLink;