"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorBarSeries = void 0;
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _helper = require("../../../lib/helper");
var _hooks = require("../../../hooks");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * There is a specific focus on the monitor's down count, the up series is not shown,
 * so we will only render the series component if there are down counts for the selected monitor.
 * @param props - the values for the monitor this chart visualizes
 */
const MonitorBarSeries = ({
  histogramSeries,
  minInterval
}) => {
  const {
    services: {
      charts
    }
  } = (0, _public.useKibana)();
  const baseTheme = charts.theme.useChartsBaseTheme();
  const theme = (0, _eui.useEuiTheme)();
  const danger = theme.euiTheme.colors.danger;
  const [getUrlParams, updateUrlParams] = (0, _hooks.useUrlParams)();
  const {
    absoluteDateRangeStart,
    absoluteDateRangeEnd
  } = getUrlParams();
  const onBrushEnd = ({
    x
  }) => {
    if (!x) {
      return;
    }
    const [min, max] = x;
    updateUrlParams({
      dateRangeStart: (0, _moment.default)(min).toISOString(),
      dateRangeEnd: (0, _moment.default)(max).toISOString()
    });
  };
  const onBarClicked = ([elementData]) => {
    updateUrlParams((0, _utils.getDateRangeFromChartElement)(elementData, minInterval));
  };
  const id = 'downSeries';
  return (0, _helper.seriesHasDownValues)(histogramSeries) ? /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: 50,
      width: '100%',
      maxWidth: '1200px',
      marginRight: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    xDomain: {
      minInterval,
      min: absoluteDateRangeStart,
      max: absoluteDateRangeEnd
    },
    onBrushEnd: onBrushEnd,
    onElementClick: onBarClicked,
    locale: _i18n.i18n.getLocale(),
    baseTheme: baseTheme
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    hide: true,
    id: "bottom",
    position: _charts.Position.Bottom,
    tickFormat: (0, _charts.timeFormatter)((0, _helper.getChartDateLabel)(absoluteDateRangeStart, absoluteDateRangeEnd))
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: id,
    color: danger,
    data: (histogramSeries || []).map(({
      timestamp,
      down
    }) => [timestamp, down]),
    name: _i18n.i18n.translate('xpack.uptime.monitorList.downLineSeries.downLabel', {
      defaultMessage: 'Down checks'
    }),
    timeZone: "local",
    xAccessor: 0
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yAccessors: [1],
    yScaleType: _charts.ScaleType.Linear
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.monitorList.noDownHistory",
      defaultMessage: "This monitor has never been {emphasizedText} during the selected time range.",
      values: {
        emphasizedText: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.uptime.monitorBarSeries.strong.downLabel', {
          defaultMessage: 'down'
        }))
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "success",
    tabIndex: 0
  }, _i18n.i18n.translate('xpack.uptime.monitorBarSeries.TextLabel', {
    defaultMessage: '--'
  })));
};
exports.MonitorBarSeries = MonitorBarSeries;