"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlSnapshotsResolutionCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _context = require("./context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  upgradeInProgressText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.upgradeInProgressText', {
    defaultMessage: 'Upgrade in progress…'
  }),
  deleteInProgressText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.deletingButtonLabel', {
    defaultMessage: 'Deletion in progress…'
  }),
  upgradeCompleteText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.upgradeCompleteText', {
    defaultMessage: 'Upgrade complete'
  }),
  deleteCompleteText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.deleteCompleteText', {
    defaultMessage: 'Deletion complete'
  }),
  upgradeFailedText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.upgradeFailedText', {
    defaultMessage: 'Upgrade failed'
  }),
  deleteFailedText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.deleteFailedText', {
    defaultMessage: 'Deletion failed'
  })
};
const MlSnapshotsResolutionCell = () => {
  const {
    snapshotState
  } = (0, _context.useMlSnapshotContext)();
  if (snapshotState.status === 'in_progress') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": "mlActionResolutionCell"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, snapshotState.action === 'delete' ? i18nTexts.deleteInProgressText : i18nTexts.upgradeInProgressText)));
  }
  if (snapshotState.status === 'complete') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": "mlActionResolutionCell"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "checkInCircleFilled",
      color: "success"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, snapshotState.action === 'delete' ? i18nTexts.deleteCompleteText : i18nTexts.upgradeCompleteText)));
  }
  if (snapshotState.status === 'error') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": "mlActionResolutionCell"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warningFilled",
      color: "danger"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, snapshotState.action === 'delete' ? i18nTexts.deleteFailedText : i18nTexts.upgradeFailedText)));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
};
exports.MlSnapshotsResolutionCell = MlSnapshotsResolutionCell;