"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestionsComponent = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _classnames = _interopRequireDefault(require("classnames"));
var _useRafState = _interopRequireDefault(require("react-use/lib/useRafState"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_memo_css = require("../use_memo_css");
var _suggestion_component = require("./suggestion_component");
var _constants = require("./constants");
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class SuggestionsComponent extends _react.PureComponent {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "childNodes", []);
    (0, _defineProperty2.default)(this, "parentNode", null);
    (0, _defineProperty2.default)(this, "scrollIntoView", (0, _utils.onRaf)(() => {
      if (this.props.index === null) {
        return;
      }
      const parent = this.parentNode;
      const child = this.childNodes[this.props.index];
      if (this.props.index == null || !parent || !child) {
        return;
      }
      const scrollTop = Math.max(Math.min(parent.scrollTop, child.offsetTop), child.offsetTop + child.offsetHeight - parent.offsetHeight);
      parent.scrollTop = scrollTop;
    }));
    (0, _defineProperty2.default)(this, "handleScroll", (0, _utils.onRaf)(() => {
      if (!this.props.loadMore || !this.parentNode) {
        return;
      }
      const position = this.parentNode.scrollTop + this.parentNode.offsetHeight;
      const height = this.parentNode.scrollHeight;
      const remaining = height - position;
      const margin = 50;
      if (!height || !position) {
        return;
      }
      if (remaining <= margin) {
        this.props.loadMore();
      }
    }));
    this.assignParentNode = this.assignParentNode.bind(this);
    this.assignChildNode = this.assignChildNode.bind(this);
  }
  assignParentNode(node) {
    this.parentNode = node;
  }
  assignChildNode(index, node) {
    this.childNodes[index] = node;
  }
  render() {
    if (!this.props.inputContainer || !this.props.show || (0, _lodash.isEmpty)(this.props.suggestions)) {
      return null;
    }
    const renderSuggestions = containerWidth => {
      const isDescriptionFittable = containerWidth >= _constants.SUGGESTIONS_LIST_REQUIRED_WIDTH;
      const suggestions = this.props.suggestions.map((suggestion, index) => {
        return /*#__PURE__*/_react.default.createElement(_suggestion_component.SuggestionComponent, {
          innerRef: this.assignChildNode,
          selected: index === this.props.index,
          index: index,
          suggestion: suggestion,
          onClick: this.props.onClick,
          onMouseEnter: this.props.onMouseEnter,
          ariaId: 'suggestion-' + index,
          key: `${suggestion.type} - ${suggestion.text}`,
          shouldDisplayDescription: isDescriptionFittable
        });
      });
      return suggestions;
    };
    return /*#__PURE__*/_react.default.createElement(ResizableSuggestionsListDiv, {
      inputContainer: this.props.inputContainer,
      suggestionsSize: this.props.size
    }, rect => /*#__PURE__*/_react.default.createElement("div", {
      id: "kbnTypeahead__items",
      role: "listbox",
      ref: this.assignParentNode,
      onScroll: this.handleScroll
    }, renderSuggestions(rect.width)));
  }
  componentDidUpdate(prevProps) {
    if (prevProps.index !== this.props.index) {
      this.scrollIntoView();
    }
  }
}
exports.SuggestionsComponent = SuggestionsComponent;
const ResizableSuggestionsListDiv = /*#__PURE__*/_react.default.memo(props => {
  const inputContainer = props.inputContainer;
  const [{
    documentHeight
  }, {
    pageYOffset
  }, containerRect] = useDimensions(inputContainer);
  const styles = (0, _use_memo_css.useMemoCss)(suggestionsStyles);
  if (!containerRect) return null;

  // reflects if the suggestions list has enough space below to be opened down
  const isSuggestionsListFittable = documentHeight - (containerRect.top + containerRect.height) > _constants.SUGGESTIONS_LIST_REQUIRED_BOTTOM_SPACE;
  const verticalListPosition = isSuggestionsListFittable ? {
    top: `${pageYOffset + containerRect.bottom - _constants.SUGGESTIONS_LIST_REQUIRED_TOP_OFFSET}px`
  } : {
    bottom: `${documentHeight - (pageYOffset + containerRect.top)}px`
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.container,
    style: {
      left: `${containerRect.left}px`,
      width: `${containerRect.width}px`,
      ...verticalListPosition
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('kbnTypeahead', {
      'kbnTypeahead--small': props.suggestionsSize === 's'
    })
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('kbnTypeahead__popover', 'eui-scrollBar', {
      ['kbnTypeahead__popover--bottom']: isSuggestionsListFittable,
      ['kbnTypeahead__popover--top']: !isSuggestionsListFittable
    })
  }, props.children(containerRect))));
});
function useDimensions(container) {
  const [documentHeight, setDocumentHeight] = (0, _useRafState.default)(() => document.documentElement.clientHeight || window.innerHeight);
  const [pageOffset, setPageOffset] = (0, _useRafState.default)(() => ({
    pageXOffset: window.pageXOffset,
    pageYOffset: window.pageYOffset
  }));
  const [containerRect, setContainerRect] = (0, _useRafState.default)(() => {
    var _container$getBoundin;
    return (_container$getBoundin = container === null || container === void 0 ? void 0 : container.getBoundingClientRect()) !== null && _container$getBoundin !== void 0 ? _container$getBoundin : null;
  });
  const updateContainerRect = _react.default.useCallback(() => {
    setContainerRect(oldRect => {
      var _container$getBoundin2;
      const newRect = (_container$getBoundin2 = container === null || container === void 0 ? void 0 : container.getBoundingClientRect()) !== null && _container$getBoundin2 !== void 0 ? _container$getBoundin2 : null;
      const rectsEqual = (0, _utils.shallowEqual)(oldRect === null || oldRect === void 0 ? void 0 : oldRect.toJSON(), newRect === null || newRect === void 0 ? void 0 : newRect.toJSON());
      return rectsEqual ? oldRect : newRect;
    });
  }, [container, setContainerRect]);
  _react.default.useEffect(() => {
    const handler = () => {
      setDocumentHeight(document.documentElement.clientHeight || window.innerHeight);
    };
    window.addEventListener('resize', handler, {
      passive: true
    });
    return () => {
      window.removeEventListener('resize', handler);
    };
  }, [setDocumentHeight]);
  _react.default.useEffect(() => {
    const handler = () => {
      setPageOffset(state => {
        const {
          pageXOffset,
          pageYOffset
        } = window;
        return state.pageXOffset !== pageXOffset || state.pageYOffset !== pageYOffset ? {
          pageXOffset,
          pageYOffset
        } : state;
      });
      updateContainerRect();
    };
    window.addEventListener('scroll', handler, {
      passive: true,
      capture: true
    });
    const resizeObserver = typeof window.ResizeObserver !== 'undefined' && new ResizeObserver(() => {
      updateContainerRect();
    });
    if (container && resizeObserver) {
      resizeObserver.observe(container);
    }
    return () => {
      window.removeEventListener('scroll', handler, {
        capture: true
      });
      if (resizeObserver) resizeObserver.disconnect();
    };
  }, [setPageOffset, container, updateContainerRect]);
  return [{
    documentHeight
  }, pageOffset, containerRect];
}
const suggestionsStyles = {
  container: context => (0, _react2.css)({
    position: 'absolute',
    zIndex: 4001,
    '.kbnTypeahead': {
      maxHeight: '60vh',
      '&.kbnTypeahead--small': {
        maxHeight: '20vh'
      }
    },
    '.kbnTypeahead__popover': {
      maxHeight: 'inherit',
      border: `1px solid ${context.euiTheme.colors.borderBaseSubdued}`,
      color: context.euiTheme.colors.text,
      backgroundColor: context.euiTheme.colors.emptyShade,
      position: 'relative',
      zIndex: context.euiTheme.levels.menu,
      width: '100%',
      overflowY: 'auto',
      '&.kbnTypeahead__popover--top': (0, _react2.css)([(0, _eui.euiShadowFlat)(context), {
        borderTopLeftRadius: context.euiTheme.border.radius.medium,
        borderTopRightRadius: context.euiTheme.border.radius.medium,
        // Clips the shadow so it doesn't show above the input (below)
        clipPath: `polygon(-50px -50px, calc(100% + 50px) -50px, calc(100% + 50px) 100%, -50px 100%)`
      }]),
      '&.kbnTypeahead__popover--bottom': (0, _react2.css)([(0, _eui.euiShadow)(context), {
        borderBottomLeftRadius: context.euiTheme.border.radius.medium,
        borderBottomRightRadius: context.euiTheme.border.radius.medium,
        // Clips the shadow so it doesn't show above the input (top)
        clipPath: `polygon(-50px 1px, calc(100% + 50px) 1px, calc(100% + 50px) calc(100% + 50px), -50px calc(100% + 50px))`
      }])
    }
  })
};