"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.canShowSavedQuery = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Determines if saving queries is allowed within the saved query management popover (still requires privileges).
 * This does not impact if queries can be loaded, which is determined by the saved query management read privilege.
 */
const canShowSavedQuery = ({
  allowSavingQueries = false,
  query,
  core
}) => {
  var _core$application$cap;
  // Don't allow saving queries by default
  if (!allowSavingQueries) {
    return false;
  }

  // Saved Queries are not supported for ES|QL (only Saved Searches)
  if ((0, _esQuery.isOfAggregateQueryType)(query)) {
    return false;
  }
  return Boolean((_core$application$cap = core.application.capabilities.savedQueryManagement) === null || _core$application$cap === void 0 ? void 0 : _core$application$cap.saveQuery);
};
exports.canShowSavedQuery = canShowSavedQuery;