"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterButtonGroup = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_memo_css = require("../../use_memo_css");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const FilterButtonGroup = ({
  items,
  attached,
  size = 'm',
  ...rest
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(filterButtonStyles);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
    className: (0, _classnames.default)('kbnFilterButtonGroup', {
      'kbnFilterButtonGroup--attached': attached,
      [`kbnFilterButtonGroup--${size}`]: size
    }),
    gutterSize: "none",
    responsive: false,
    css: styles.wrapper
  }, rest), items.map((item, i) => item == null ? undefined : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: i,
    grow: false
  }, item)));
};
exports.FilterButtonGroup = FilterButtonGroup;
const filterButtonStyles = {
  wrapper: ({
    euiTheme
  }) => (0, _react2.css)({
    position: 'relative',
    height: euiTheme.size.xxl,
    backgroundColor: euiTheme.colors.backgroundBaseFormsPrepend,
    borderRadius: euiTheme.border.radius.medium,
    '&::after': {
      content: "''",
      position: 'absolute',
      inset: 0,
      border: `${euiTheme.border.thin} solid ${euiTheme.colors.borderBasePlain}`,
      borderRadius: 'inherit',
      pointerEvents: 'none'
    },
    // Targets any interactable elements
    '*:enabled': {
      transform: 'none !important'
    },
    '&.kbnFilterButtonGroup--s': {
      height: euiTheme.size.xl
    },
    ' &.kbnFilterButtonGroup--attached': {
      borderTopRightRadius: 0,
      borderBottomRightRadius: 0
    },
    '> *:not(:last-of-type)': {
      borderRight: `1px solid ${euiTheme.colors.borderBasePlain}`
    }
  })
};