"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformFilters = exports.filterTransforms = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../common/constants");
var _transform = require("../../../../../../common/types/transform");
var _transform_task_state_badge = require("./transform_task_state_badge");
var _transform_health_colored_dot = require("./transform_health_colored_dot");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformFilters = exports.transformFilters = [{
  type: 'field_value_selection',
  field: 'stats.state',
  name: _i18n.i18n.translate('xpack.transform.statusFilter', {
    defaultMessage: 'Status'
  }),
  multiSelect: 'or',
  options: Object.values(_constants.TRANSFORM_STATE).map(val => ({
    value: val,
    name: val,
    view: /*#__PURE__*/_react.default.createElement(_transform_task_state_badge.TransformTaskStateBadge, {
      state: val
    })
  }))
}, {
  type: 'field_value_selection',
  field: 'mode',
  name: _i18n.i18n.translate('xpack.transform.modeFilter', {
    defaultMessage: 'Mode'
  }),
  multiSelect: false,
  options: Object.values(_constants.TRANSFORM_MODE).map(val => ({
    value: val,
    name: val,
    view: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      className: "transform__TaskModeBadge",
      color: "hollow"
    }, val)
  }))
}, {
  type: 'field_value_selection',
  field: 'stats.health.status',
  name: _i18n.i18n.translate('xpack.transform.healthFilter', {
    defaultMessage: 'Health'
  }),
  multiSelect: false,
  options: Object.values(_constants.TRANSFORM_HEALTH_STATUS).map(val => ({
    value: val,
    name: val,
    view: /*#__PURE__*/_react.default.createElement(_transform_health_colored_dot.TransformHealthColoredDot, {
      compact: true,
      showToolTip: false,
      healthStatus: val
    })
  }))
}];
function stringMatch(str, substr) {
  try {
    return typeof str === 'string' && typeof substr === 'string' && str.toLowerCase().match(substr.toLowerCase()) === null === false;
  } catch (error) {
    return false;
  }
}
const filterTransforms = (transforms, clauses) => {
  // keep count of the number of matches we make as we're looping over the clauses
  // we only want to return transforms which match all clauses, i.e. each search term is ANDed
  // { transform-one:  { transform: { id: transform-one, config: {}, state: {}, ... }, count: 0 }, transform-two: {...} }
  const matches = transforms.reduce((p, c) => {
    p[c.id] = {
      transform: c,
      count: 0
    };
    return p;
  }, {});
  clauses.forEach(c => {
    // the search term could be negated with a minus, e.g. -bananas
    const bool = c.match === 'must';
    let ts = [];
    if (c.type === 'term') {
      // filter term based clauses, e.g. bananas
      // match on ID and description
      // if the term has been negated, AND the matches
      if (bool === true) {
        ts = transforms.filter(transform => stringMatch(transform.id, c.value) === bool || stringMatch(transform.config.description, c.value) === bool);
      } else {
        ts = transforms.filter(transform => stringMatch(transform.id, c.value) === bool && stringMatch(transform.config.description, c.value) === bool);
      }
    } else {
      // filter other clauses, i.e. the mode and status filters
      if (c.type !== 'is' && Array.isArray(c.value)) {
        // the status value is an array of string(s) e.g. ['failed', 'stopped']
        ts = transforms.filter(transform => transform.stats && c.value.includes(transform.stats.state));
      } else {
        ts = transforms.filter(transform => {
          if (!transform.stats) return false;
          if (c.type === 'field' && c.field === 'stats.health.status') {
            var _transform$stats$heal;
            return ((_transform$stats$heal = transform.stats.health) === null || _transform$stats$heal === void 0 ? void 0 : _transform$stats$heal.status) === c.value;
          }
          if (c.type === 'field' && c.field === 'mode') {
            return transform.mode === c.value;
          }
          if (c.type === 'field' && c.field === 'type') {
            if (c.value === _constants.TRANSFORM_FUNCTION.PIVOT) {
              return (0, _transform.isPivotTransform)(transform.config);
            }
            if (c.value === _constants.TRANSFORM_FUNCTION.LATEST) {
              return (0, _transform.isLatestTransform)(transform.config);
            }
          }
          return false;
        });
      }
    }
    ts.forEach(t => matches[t.id].count++);
  });

  // loop through the matches and return only transforms which have match all the clauses
  const filtered = Object.values(matches).filter(m => (m && m.count) >= clauses.length).map(m => m.transform);
  return filtered;
};
exports.filterTransforms = filterTransforms;