"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeFormField = void 0;
var _mlNestedProperty = require("@kbn/ml-nested-property");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// The form state defines a flat structure of names for form fields.
// This is a flat structure regardless of whether the final config object will be nested.
// For example, `destinationIndex` and `destinationIngestPipeline` will later be nested under `dest`.

const initializeFormField = (formFieldName, configFieldName, config, overloads) => {
  const defaultValue = (overloads === null || overloads === void 0 ? void 0 : overloads.defaultValue) !== undefined ? overloads.defaultValue : '';
  const rawValue = (0, _mlNestedProperty.getNestedProperty)(config !== null && config !== void 0 ? config : {}, configFieldName, undefined);
  const value = rawValue !== null && rawValue !== undefined ? rawValue.toString() : '';
  return {
    formFieldName,
    configFieldName,
    defaultValue,
    dependsOn: [],
    errorMessages: [],
    isNullable: false,
    isOptional: true,
    validator: 'stringValidator',
    value,
    valueParser: 'defaultParser',
    ...(overloads !== undefined ? {
      ...overloads
    } : {})
  };
};
exports.initializeFormField = initializeFormField;