"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Frequency", {
  enumerable: true,
  get: function () {
    return _rrule.Frequency;
  }
});
Object.defineProperty(exports, "IdleTaskWithExpiredRunAt", {
  enumerable: true,
  get: function () {
    return _mark_available_tasks_as_claimed.IdleTaskWithExpiredRunAt;
  }
});
Object.defineProperty(exports, "RunningOrClaimingTaskWithExpiredRetryAt", {
  enumerable: true,
  get: function () {
    return _mark_available_tasks_as_claimed.RunningOrClaimingTaskWithExpiredRetryAt;
  }
});
Object.defineProperty(exports, "TaskCost", {
  enumerable: true,
  get: function () {
    return _task.TaskCost;
  }
});
Object.defineProperty(exports, "TaskErrorSource", {
  enumerable: true,
  get: function () {
    return _task_running.TaskErrorSource;
  }
});
Object.defineProperty(exports, "TaskPriority", {
  enumerable: true,
  get: function () {
    return _task.TaskPriority;
  }
});
Object.defineProperty(exports, "TaskStatus", {
  enumerable: true,
  get: function () {
    return _task.TaskStatus;
  }
});
Object.defineProperty(exports, "Weekday", {
  enumerable: true,
  get: function () {
    return _rrule.Weekday;
  }
});
Object.defineProperty(exports, "aggregateTaskOverduePercentilesForType", {
  enumerable: true,
  get: function () {
    return _aggregate_task_overdue_percentiles_for_type.aggregateTaskOverduePercentilesForType;
  }
});
Object.defineProperty(exports, "asInterval", {
  enumerable: true,
  get: function () {
    return _intervals.asInterval;
  }
});
exports.config = void 0;
Object.defineProperty(exports, "createTaskRunError", {
  enumerable: true,
  get: function () {
    return _task_running.createTaskRunError;
  }
});
Object.defineProperty(exports, "getOldestIdleActionTask", {
  enumerable: true,
  get: function () {
    return _oldest_idle_action_task.getOldestIdleActionTask;
  }
});
Object.defineProperty(exports, "isUnrecoverableError", {
  enumerable: true,
  get: function () {
    return _task_running.isUnrecoverableError;
  }
});
exports.plugin = void 0;
Object.defineProperty(exports, "scheduleRruleSchemaV1", {
  enumerable: true,
  get: function () {
    return _saved_objects.scheduleRruleSchemaV1;
  }
});
Object.defineProperty(exports, "scheduleRruleSchemaV2", {
  enumerable: true,
  get: function () {
    return _saved_objects.scheduleRruleSchemaV2;
  }
});
Object.defineProperty(exports, "throwRetryableError", {
  enumerable: true,
  get: function () {
    return _task_running.throwRetryableError;
  }
});
Object.defineProperty(exports, "throwUnrecoverableError", {
  enumerable: true,
  get: function () {
    return _task_running.throwUnrecoverableError;
  }
});
var _lodash = require("lodash");
var _config = require("./config");
var _rrule = require("@kbn/rrule");
var _saved_objects = require("./saved_objects");
var _task = require("./task");
var _intervals = require("./lib/intervals");
var _task_running = require("./task_running");
var _oldest_idle_action_task = require("./queries/oldest_idle_action_task");
var _mark_available_tasks_as_claimed = require("./queries/mark_available_tasks_as_claimed");
var _aggregate_task_overdue_percentiles_for_type = require("./queries/aggregate_task_overdue_percentiles_for_type");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const plugin = async initContext => {
  const {
    TaskManagerPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new TaskManagerPlugin(initContext);
};
exports.plugin = plugin;
const config = exports.config = {
  schema: _config.configSchema,
  deprecations: ({
    deprecate
  }) => {
    return [deprecate('max_workers', 'a future version', {
      level: 'warning',
      message: `Configuring "xpack.task_manager.max_workers" is deprecated and will be removed in a future version. Remove this setting and use "xpack.task_manager.capacity" instead.`
    }), deprecate('claim_strategy', 'a future version', {
      level: 'warning',
      message: `Configuring "xpack.task_manager.claim_strategy" is deprecated and will be removed in a future version. This setting should be removed.`
    }), (settings, fromPath, addDeprecation) => {
      const taskManager = (0, _lodash.get)(settings, fromPath);
      if (taskManager !== null && taskManager !== void 0 && taskManager.index) {
        addDeprecation({
          level: 'critical',
          configPath: `${fromPath}.index`,
          documentationUrl: 'https://ela.st/kbn-remove-legacy-multitenancy',
          message: `"${fromPath}.index" is deprecated. Multitenancy by changing "kibana.index" will not be supported starting in 8.0. See https://ela.st/kbn-remove-legacy-multitenancy for more details`,
          correctiveActions: {
            manualSteps: [`If you rely on this setting to achieve multitenancy you should use Spaces, cross-cluster replication, or cross-cluster search instead.`, `To migrate to Spaces, we encourage using saved object management to export your saved objects from a tenant into the default tenant in a space.`]
          }
        });
      }
    }, (settings, fromPath, addDeprecation) => {
      const taskManager = (0, _lodash.get)(settings, fromPath);
      if ((taskManager === null || taskManager === void 0 ? void 0 : taskManager.max_workers) > _config.MAX_WORKERS_LIMIT) {
        addDeprecation({
          level: 'critical',
          configPath: `${fromPath}.max_workers`,
          message: `setting "${fromPath}.max_workers" (${taskManager === null || taskManager === void 0 ? void 0 : taskManager.max_workers}) greater than ${_config.MAX_WORKERS_LIMIT} is deprecated.`,
          correctiveActions: {
            manualSteps: [`Maximum allowed value of "${fromPath}.max_workers" is ${_config.MAX_WORKERS_LIMIT}.` + `Replace "${fromPath}.max_workers: ${taskManager === null || taskManager === void 0 ? void 0 : taskManager.max_workers}" with (${_config.MAX_WORKERS_LIMIT}).`]
          }
        });
      }
    }];
  },
  exposeToUsage: {
    claim_strategy: true,
    discovery: {
      active_nodes_lookback: true
    },
    unsafe: {
      exclude_task_types: true
    }
  }
};