"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLastSuccessfulCheckScreenshot = exports.createLastSuccessfulCheckRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _get_journey_screenshot = require("../../queries/get_journey_screenshot");
var _get_last_successful_check = require("../../queries/get_last_successful_check");
var _runtime_types = require("../../../common/runtime_types");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createLastSuccessfulCheckRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.SYNTHETICS_SUCCESSFUL_CHECK,
  validate: {
    query: _configSchema.schema.object({
      monitorId: _configSchema.schema.string(),
      stepIndex: _configSchema.schema.number(),
      timestamp: _configSchema.schema.string(),
      location: _configSchema.schema.maybe(_configSchema.schema.string())
    })
  },
  handler: async routeProps => {
    return await getLastSuccessfulCheckScreenshot(routeProps);
  }
});
exports.createLastSuccessfulCheckRoute = createLastSuccessfulCheckRoute;
const getLastSuccessfulCheckScreenshot = async ({
  response,
  request,
  syntheticsEsClient
}) => {
  const {
    timestamp,
    monitorId,
    stepIndex,
    location
  } = request.query;
  const check = await (0, _get_last_successful_check.getLastSuccessfulCheck)({
    syntheticsEsClient,
    monitorId,
    timestamp,
    location
  });
  if (check === null) {
    return response.notFound();
  }
  if (!check.monitor.check_group) {
    return response.ok({
      body: check
    });
  }
  const screenshot = await (0, _get_journey_screenshot.getJourneyScreenshot)({
    syntheticsEsClient,
    checkGroup: check.monitor.check_group,
    stepIndex
  });
  if (screenshot === null) {
    return response.ok({
      body: check
    });
  }
  if (check.synthetics) {
    check.synthetics.isScreenshotRef = (0, _runtime_types.isRefResult)(screenshot);
    check.synthetics.isFullScreenshot = (0, _runtime_types.isFullScreenshot)(screenshot);
  }
  return response.ok({
    body: check
  });
};
exports.getLastSuccessfulCheckScreenshot = getLastSuccessfulCheckScreenshot;