"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteSyntheticsMonitorBulkRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _delete_monitor_api = require("../services/delete_monitor_api");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteSyntheticsMonitorBulkRoute = () => ({
  method: 'POST',
  path: _constants.SYNTHETICS_API_URLS.SYNTHETICS_MONITORS + '/_bulk_delete',
  validate: {},
  validation: {
    request: {
      body: _configSchema.schema.object({
        ids: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
          minSize: 1
        })
      })
    }
  },
  handler: async routeContext => {
    const {
      request
    } = routeContext;
    const {
      ids: idsToDelete
    } = request.body || {};
    const deleteMonitorAPI = new _delete_monitor_api.DeleteMonitorAPI(routeContext);
    const {
      errors,
      result
    } = await deleteMonitorAPI.execute({
      monitorIds: idsToDelete
    });
    return {
      result,
      errors
    };
  }
});
exports.deleteSyntheticsMonitorBulkRoute = deleteSyntheticsMonitorBulkRoute;