"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUngroupedReasonMessage = exports.getReasonMessageForTimeWindow = exports.getReasonMessage = exports.getMonitorSummary = exports.getMonitorAlertDocument = exports.UNAVAILABLE_LABEL = exports.HOST_LABEL = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _status_rule = require("../../../common/rules/status_rule");
var _common = require("../common");
var _action_variables = require("../action_variables");
var _field_names = require("../../../common/field_names");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMonitorAlertDocument = (monitorSummary, locationNames, locationIds, useLatestChecks, threshold) => {
  var _ref, _monitorSummary$check, _monitorSummary$check2, _monitorSummary$monit;
  return {
    [_field_names.MONITOR_ID]: monitorSummary.monitorId,
    [_field_names.MONITOR_TYPE]: monitorSummary.monitorType,
    [_field_names.MONITOR_NAME]: monitorSummary.monitorName,
    [_field_names.SERVICE_NAME]: monitorSummary.serviceName,
    [_field_names.URL_FULL]: monitorSummary.monitorUrl,
    [_field_names.OBSERVER_GEO_NAME]: locationNames,
    [_field_names.OBSERVER_NAME]: locationIds,
    [_field_names.ERROR_MESSAGE]: monitorSummary.lastErrorMessage,
    // done to avoid assigning null to the field
    [_field_names.ERROR_STACK_TRACE]: monitorSummary.lastErrorStack ? monitorSummary.lastErrorStack : undefined,
    [_field_names.AGENT_NAME]: monitorSummary.hostName,
    [_ruleDataUtils.ALERT_REASON]: monitorSummary.reason,
    [_field_names.STATE_ID]: monitorSummary.stateId,
    'location.id': locationIds,
    'location.name': locationNames,
    labels: monitorSummary.labels,
    configId: monitorSummary.configId,
    'kibana.alert.evaluation.threshold': threshold,
    'kibana.alert.evaluation.value': (_ref = useLatestChecks ? (_monitorSummary$check = monitorSummary.checks) === null || _monitorSummary$check === void 0 ? void 0 : _monitorSummary$check.downWithinXChecks : (_monitorSummary$check2 = monitorSummary.checks) === null || _monitorSummary$check2 === void 0 ? void 0 : _monitorSummary$check2.down) !== null && _ref !== void 0 ? _ref : 1,
    'monitor.tags': (_monitorSummary$monit = monitorSummary.monitorTags) !== null && _monitorSummary$monit !== void 0 ? _monitorSummary$monit : []
  };
};
exports.getMonitorAlertDocument = getMonitorAlertDocument;
const DOWN_LABEL = _i18n.i18n.translate('xpack.synthetics.alerts.monitorStatus.downLabel', {
  defaultMessage: `down`
});
const PENDING_LABEL = _i18n.i18n.translate('xpack.synthetics.alerts.monitorStatus.pendingLabel', {
  defaultMessage: `pending`
});
const RECOVERED_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorStatus.recoveredLabel', {
  defaultMessage: 'recovered'
});
const statusMap = {
  down: DOWN_LABEL,
  pending: PENDING_LABEL,
  recovered: RECOVERED_LABEL
};
const getMonitorSummary = ({
  monitorInfo,
  locationId,
  configId,
  tz,
  dateFormat,
  reason,
  checks,
  params
}) => {
  var _monitorInfo$monitor$, _monitorInfo$monitor, _monitorInfo$monitor2, _monitorInfo$observer, _monitorInfo$observer2, _monitorInfo$observer3, _monitorInfo$monitor3, _monitorInfo$state, _locationId$join, _locationId$join2, _monitorInfo$url, _monitorInfo$monitor4, _monitorInfo$monitor5, _monitorInfo$monitor6, _monitorInfo$error, _monitorInfo$error2, _monitorInfo$error3, _monitorInfo$service, _monitorInfo$agent;
  const {
    downThreshold
  } = (0, _status_rule.getConditionType)(params === null || params === void 0 ? void 0 : params.condition);
  const monitorName = (_monitorInfo$monitor$ = monitorInfo === null || monitorInfo === void 0 ? void 0 : (_monitorInfo$monitor = monitorInfo.monitor) === null || _monitorInfo$monitor === void 0 ? void 0 : _monitorInfo$monitor.name) !== null && _monitorInfo$monitor$ !== void 0 ? _monitorInfo$monitor$ : monitorInfo === null || monitorInfo === void 0 ? void 0 : (_monitorInfo$monitor2 = monitorInfo.monitor) === null || _monitorInfo$monitor2 === void 0 ? void 0 : _monitorInfo$monitor2.id;
  const locationName = (_monitorInfo$observer = monitorInfo === null || monitorInfo === void 0 ? void 0 : (_monitorInfo$observer2 = monitorInfo.observer) === null || _monitorInfo$observer2 === void 0 ? void 0 : (_monitorInfo$observer3 = _monitorInfo$observer2.geo) === null || _monitorInfo$observer3 === void 0 ? void 0 : _monitorInfo$observer3.name) !== null && _monitorInfo$observer !== void 0 ? _monitorInfo$observer : _constants.UNNAMED_LOCATION;
  const formattedLocationName = Array.isArray(locationName) ? locationName.join(` ${_common.AND_LABEL} `) : locationName;

  // When the monitor is pending there is no timestamp for the last ping
  const {
    timestamp,
    checkedAt
  } = monitorInfo && '@timestamp' in monitorInfo ? {
    timestamp: monitorInfo['@timestamp'],
    checkedAt: (0, _moment.default)(monitorInfo['@timestamp']).tz(tz || 'UTC').format(dateFormat)
  } : {
    timestamp: undefined,
    checkedAt: undefined
  };
  const typeToLabelMap = {
    http: 'HTTP',
    tcp: 'TCP',
    icmp: 'ICMP',
    browser: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.browser.label', {
      defaultMessage: 'browser'
    })
  };
  const typeToUrlLabelMap = {
    http: 'URL',
    tcp: HOST_LABEL,
    icmp: HOST_LABEL,
    browser: 'URL'
  };
  const monitorType = (_monitorInfo$monitor3 = monitorInfo.monitor) === null || _monitorInfo$monitor3 === void 0 ? void 0 : _monitorInfo$monitor3.type;
  const stateId = (_monitorInfo$state = monitorInfo.state) === null || _monitorInfo$state === void 0 ? void 0 : _monitorInfo$state.id;
  return {
    checkedAt,
    locationId: (_locationId$join = locationId === null || locationId === void 0 ? void 0 : (_locationId$join2 = locationId.join) === null || _locationId$join2 === void 0 ? void 0 : _locationId$join2.call(locationId, ` ${_common.AND_LABEL} `)) !== null && _locationId$join !== void 0 ? _locationId$join : '',
    configId,
    monitorUrl: ((_monitorInfo$url = monitorInfo.url) === null || _monitorInfo$url === void 0 ? void 0 : _monitorInfo$url.full) || UNAVAILABLE_LABEL,
    monitorUrlLabel: typeToUrlLabelMap[monitorType] || 'URL',
    monitorId: (_monitorInfo$monitor4 = monitorInfo.monitor) === null || _monitorInfo$monitor4 === void 0 ? void 0 : _monitorInfo$monitor4.id,
    monitorName,
    monitorType: typeToLabelMap[(_monitorInfo$monitor5 = monitorInfo.monitor) === null || _monitorInfo$monitor5 === void 0 ? void 0 : _monitorInfo$monitor5.type] || ((_monitorInfo$monitor6 = monitorInfo.monitor) === null || _monitorInfo$monitor6 === void 0 ? void 0 : _monitorInfo$monitor6.type),
    lastErrorMessage: (_monitorInfo$error = monitorInfo.error) === null || _monitorInfo$error === void 0 ? void 0 : _monitorInfo$error.message,
    // done to avoid assigning null to the field
    lastErrorStack: (_monitorInfo$error2 = monitorInfo.error) !== null && _monitorInfo$error2 !== void 0 && _monitorInfo$error2.stack_trace ? (_monitorInfo$error3 = monitorInfo.error) === null || _monitorInfo$error3 === void 0 ? void 0 : _monitorInfo$error3.stack_trace : undefined,
    serviceName: (_monitorInfo$service = monitorInfo.service) === null || _monitorInfo$service === void 0 ? void 0 : _monitorInfo$service.name,
    labels: monitorInfo.labels,
    locationName: formattedLocationName,
    locationNames: formattedLocationName,
    hostName: (_monitorInfo$agent = monitorInfo.agent) === null || _monitorInfo$agent === void 0 ? void 0 : _monitorInfo$agent.name,
    status: statusMap[reason],
    stateId,
    [_action_variables.ALERT_REASON_MSG]: getReasonMessage({
      name: monitorName,
      location: formattedLocationName,
      reason,
      checks,
      params
    }),
    checks,
    downThreshold,
    timestamp,
    monitorTags: monitorInfo.tags
  };
};
exports.getMonitorSummary = getMonitorSummary;
const getUngroupedReasonMessage = ({
  statusConfigs,
  monitorName,
  params,
  reason
}) => {
  const {
    useLatestChecks,
    numberOfChecks,
    timeWindow,
    downThreshold,
    locationsThreshold
  } = (0, _status_rule.getConditionType)(params.condition);
  const status = statusMap[reason];
  const locationDetails = statusConfigs.map(c => {
    var _c$latestPing, _c$latestPing$observe;
    let downCount = 1;
    if ('checks' in c) {
      var _c$checks, _c$checks2;
      downCount = useLatestChecks ? (_c$checks = c.checks) === null || _c$checks === void 0 ? void 0 : _c$checks.downWithinXChecks : (_c$checks2 = c.checks) === null || _c$checks2 === void 0 ? void 0 : _c$checks2.down;
    }
    return _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.reasonMessage.locationDetails', {
      defaultMessage: '{downCount} {downCount, plural, one {time} other {times}} from {locName}',
      values: {
        locName: ((_c$latestPing = c.latestPing) === null || _c$latestPing === void 0 ? void 0 : (_c$latestPing$observe = _c$latestPing.observer.geo) === null || _c$latestPing$observe === void 0 ? void 0 : _c$latestPing$observe.name) || 'monitorInfo' in c && c.monitorInfo.observer.geo.name || c.locationId,
        downCount
      }
    });
  }).join(` ${_common.AND_LABEL} `);
  if (reason === 'pending') {
    return _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.reasonMessage.location.ungrouped.multiple.pending', {
      defaultMessage: `Monitor "{name}" is {status} {locationDetails}.`,
      values: {
        name: monitorName,
        status,
        locationDetails
      }
    });
  }
  return _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.reasonMessage.location.ungrouped.multiple', {
    defaultMessage: `Monitor "{name}" is {status} {locationDetails}. Alert when down {threshold} {threshold, plural, one {time} other {times}} {condition} from at least {locationsThreshold} {locationsThreshold, plural, one {location} other {locations}}.`,
    values: {
      name: monitorName,
      status,
      threshold: downThreshold,
      locationsThreshold,
      condition: useLatestChecks ? _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.reasonMessage.condition.latestChecks', {
        defaultMessage: 'out of the last {numberOfChecks} checks',
        values: {
          numberOfChecks
        }
      }) : _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.reasonMessage.condition.timeWindow', {
        defaultMessage: 'within the last {time} {unit}',
        values: {
          time: timeWindow.size,
          unit: (0, _common.getTimeUnitLabel)(timeWindow)
        }
      }),
      locationDetails
    }
  });
};
exports.getUngroupedReasonMessage = getUngroupedReasonMessage;
const getReasonMessage = ({
  name,
  reason,
  location,
  checks,
  params
}) => {
  const status = statusMap[reason];
  if (reason === 'pending') {
    return _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.reasonMessage.pending', {
      defaultMessage: `Monitor "{name}" from {location} is {status}.`,
      values: {
        name,
        status,
        location
      }
    });
  }
  const {
    useTimeWindow,
    numberOfChecks,
    locationsThreshold,
    downThreshold
  } = (0, _status_rule.getConditionType)(params === null || params === void 0 ? void 0 : params.condition);
  if (useTimeWindow) {
    return getReasonMessageForTimeWindow({
      name,
      location,
      reason,
      params
    });
  }
  return _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.reasonMessage.new', {
    defaultMessage: `Monitor "{name}" from {location} is {status}. {checksSummary}Alert when {downThreshold} out of the last {numberOfChecks} checks are down from at least {locationsThreshold} {locationsThreshold, plural, one {location} other {locations}}.`,
    values: {
      name,
      status,
      location,
      downThreshold,
      locationsThreshold,
      numberOfChecks,
      checksSummary: checks ? _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.reasonMessage.checksSummary', {
        defaultMessage: 'Monitor is down {downChecks} {downChecks, plural, one {time} other {times}} within the last {numberOfChecks} checks. ',
        values: {
          downChecks: checks.downWithinXChecks,
          numberOfChecks
        }
      }) : ''
    }
  });
};
exports.getReasonMessage = getReasonMessage;
const getReasonMessageForTimeWindow = ({
  name,
  location,
  reason,
  params
}) => {
  const status = statusMap[reason];
  const {
    timeWindow,
    locationsThreshold,
    downThreshold
  } = (0, _status_rule.getConditionType)(params === null || params === void 0 ? void 0 : params.condition);
  return _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.reasonMessage.timeBased', {
    defaultMessage: `Monitor "{name}" from {location} is {status}. Alert when {downThreshold} checks are down within the last {size} {unitLabel} from at least {locationsThreshold} {locationsThreshold, plural, one {location} other {locations}}.`,
    values: {
      name,
      status,
      location,
      downThreshold,
      unitLabel: (0, _common.getTimeUnitLabel)(timeWindow),
      locationsThreshold,
      size: timeWindow.size
    }
  });
};
exports.getReasonMessageForTimeWindow = getReasonMessageForTimeWindow;
const UNAVAILABLE_LABEL = exports.UNAVAILABLE_LABEL = _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.unavailableUrlLabel', {
  defaultMessage: `(unavailable)`
});
const HOST_LABEL = exports.HOST_LABEL = _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.host.label', {
  defaultMessage: 'Host'
});