"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRelativeViewInAppUrl = exports.getFullViewInAppMessage = exports.getDeletedMonitorOrLocationSummary = exports.getDefaultRecoveredSummary = exports.getDefaultLinkMessage = exports.generateFilterDSL = exports.generateAlertMessage = exports.formatFilterString = exports.SyntheticsRuleTypeAlertDefinition = exports.AND_LABEL = void 0;
exports.getTimeUnitLabel = getTimeUnitLabel;
exports.updateState = exports.syntheticsRuleTypeFieldMap = exports.setRecoveredAlertsContext = exports.hasFilters = exports.getViewInAppUrl = exports.getUpMonitorRecoverySummary = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _Either = require("fp-ts/Either");
var _mustache = _interopRequireDefault(require("mustache"));
var _common = require("@kbn/observability-plugin/common");
var _common2 = require("@kbn/spaces-plugin/common");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
var _synthetics_rule_field_map = require("../../common/rules/synthetics_rule_field_map");
var _lib = require("../../common/lib");
var _synthetics_alerts = require("../../common/constants/synthetics_alerts");
var _get_index_pattern = require("../queries/get_index_pattern");
var _message_utils = require("./status_rule/message_utils");
var _common3 = require("../../common/runtime_types/alert_rules/common");
var _get_synthetics_monitor_url = require("../../common/utils/get_synthetics_monitor_url");
var _action_variables = require("./action_variables");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateState = (state, isTriggeredNow, meta) => {
  const now = new Date().toISOString();
  const decoded = _common3.SyntheticsCommonStateCodec.decode(state);
  if (!(0, _Either.isRight)(decoded)) {
    const triggerVal = isTriggeredNow ? now : undefined;
    return {
      firstCheckedAt: now,
      firstTriggeredAt: triggerVal,
      isTriggered: isTriggeredNow,
      lastTriggeredAt: triggerVal,
      lastCheckedAt: now,
      lastResolvedAt: undefined,
      meta: {}
    };
  }
  const {
    firstCheckedAt,
    firstTriggeredAt,
    lastTriggeredAt,
    // this is the stale trigger status, we're naming it `wasTriggered`
    // to differentiate it from the `isTriggeredNow` param
    isTriggered: wasTriggered,
    lastResolvedAt
  } = decoded.right;
  return {
    meta,
    firstCheckedAt: firstCheckedAt !== null && firstCheckedAt !== void 0 ? firstCheckedAt : now,
    firstTriggeredAt: isTriggeredNow && !firstTriggeredAt ? now : firstTriggeredAt,
    lastCheckedAt: now,
    lastTriggeredAt: isTriggeredNow ? now : lastTriggeredAt,
    lastResolvedAt: !isTriggeredNow && wasTriggered ? now : lastResolvedAt,
    isTriggered: isTriggeredNow
  };
};
exports.updateState = updateState;
const generateAlertMessage = (messageTemplate, fields) => {
  return _mustache.default.render(messageTemplate, {
    context: {
      ...fields
    },
    state: {
      ...fields
    }
  });
};
exports.generateAlertMessage = generateAlertMessage;
const getFullViewInAppMessage = (basePath, spaceId, relativeViewInAppUrl) => {
  const relativeLinkLabel = _i18n.i18n.translate('xpack.synthetics.alerts.monitorStatus.relativeLink.label', {
    defaultMessage: `- Relative link`
  });
  const absoluteLinkLabel = _i18n.i18n.translate('xpack.synthetics.alerts.monitorStatus.absoluteLink.label', {
    defaultMessage: `- Link`
  });
  if (basePath.publicBaseUrl) {
    return `${absoluteLinkLabel}: ${getViewInAppUrl(basePath, spaceId, relativeViewInAppUrl)}`;
  } else {
    return `${relativeLinkLabel}: ${getViewInAppUrl(basePath, spaceId, relativeViewInAppUrl)}`;
  }
};
exports.getFullViewInAppMessage = getFullViewInAppMessage;
const getViewInAppUrl = (basePath, spaceId, relativeViewInAppUrl) => (0, _common2.addSpaceIdToPath)(basePath.publicBaseUrl, spaceId, relativeViewInAppUrl);
exports.getViewInAppUrl = getViewInAppUrl;
const getRelativeViewInAppUrl = ({
  configId,
  stateId,
  locationId
}) => {
  return (0, _get_synthetics_monitor_url.getSyntheticsErrorRouteFromMonitorId)({
    configId,
    stateId,
    locationId
  });
};
exports.getRelativeViewInAppUrl = getRelativeViewInAppUrl;
const setRecoveredAlertsContext = ({
  alertsClient,
  basePath,
  spaceId,
  staleDownConfigs = {},
  stalePendingConfigs = {},
  upConfigs,
  dateFormat,
  tz,
  params,
  groupByLocation
}) => {
  var _alertsClient$getReco;
  const recoveredAlerts = (_alertsClient$getReco = alertsClient.getRecoveredAlerts()) !== null && _alertsClient$getReco !== void 0 ? _alertsClient$getReco : [];
  for (const recoveredAlert of recoveredAlerts) {
    const recoveredAlertId = recoveredAlert.alert.getId();
    const alertUuid = recoveredAlert.alert.getUuid();
    const alertHit = recoveredAlert.hit;
    const alertState = recoveredAlert.alert.getState();
    const configId = alertHit === null || alertHit === void 0 ? void 0 : alertHit.configId;
    const locationIds = alertHit !== null && alertHit !== void 0 && alertHit['location.id'] ? [alertHit === null || alertHit === void 0 ? void 0 : alertHit['location.id']].flat() : [];
    const locationName = alertHit !== null && alertHit !== void 0 && alertHit['observer.geo.name'] ? [alertHit === null || alertHit === void 0 ? void 0 : alertHit['observer.geo.name']].flat() : [];
    let syntheticsStateId = alertHit === null || alertHit === void 0 ? void 0 : alertHit['monitor.state.id'];
    let recoveryReason = _i18n.i18n.translate('xpack.synthetics.alerts.monitorStatus.defaultRecovery.reason', {
      defaultMessage: `the alert condition is no longer met`
    });
    let recoveryStatus = _i18n.i18n.translate('xpack.synthetics.alerts.monitorStatus.defaultRecovery.status', {
      defaultMessage: `has recovered`
    });
    let isUp = false;
    let linkMessage = getDefaultLinkMessage({
      basePath,
      spaceId,
      syntheticsStateId,
      configId,
      locationId: locationIds[0]
    });
    let monitorSummary = getDefaultRecoveredSummary({
      recoveredAlert,
      tz,
      dateFormat,
      params
    });
    let lastErrorMessage = alertHit === null || alertHit === void 0 ? void 0 : alertHit['error.message'];
    if (!groupByLocation && monitorSummary) {
      const formattedLocationNames = locationName.join(` ${AND_LABEL} `);
      const formattedLocationIds = locationIds.join(` ${AND_LABEL} `);
      monitorSummary.locationNames = formattedLocationNames;
      monitorSummary.locationName = formattedLocationNames;
      monitorSummary.locationId = formattedLocationIds;
    }
    if (recoveredAlertId && locationIds && (staleDownConfigs[recoveredAlertId] || stalePendingConfigs[recoveredAlertId])) {
      const summary = getDeletedMonitorOrLocationSummary({
        staleConfigs: staleDownConfigs[recoveredAlertId] ? staleDownConfigs : stalePendingConfigs,
        recoveredAlertId,
        locationIds,
        dateFormat,
        tz,
        params
      });
      if (summary) {
        monitorSummary = {
          ...monitorSummary,
          ...summary.monitorSummary
        };
        recoveryStatus = summary.recoveryStatus;
        recoveryReason = summary.recoveryReason;
        lastErrorMessage = summary.lastErrorMessage;
        syntheticsStateId = summary.stateId ? summary.stateId : syntheticsStateId;
      }
      // Cannot display link message for deleted monitors or deleted locations
      linkMessage = '';
    }
    if (configId && recoveredAlertId && locationIds && upConfigs[recoveredAlertId]) {
      const summary = getUpMonitorRecoverySummary({
        upConfigs,
        recoveredAlertId,
        alertHit,
        locationIds,
        configId,
        basePath,
        spaceId,
        dateFormat,
        tz,
        params
      });
      if (summary) {
        monitorSummary = {
          ...monitorSummary,
          ...summary.monitorSummary
        };
        recoveryStatus = summary.recoveryStatus;
        recoveryReason = summary.recoveryReason;
        isUp = summary.isUp;
        lastErrorMessage = summary.lastErrorMessage;
        linkMessage = summary.linkMessage ? summary.linkMessage : linkMessage;
        syntheticsStateId = summary.stateId ? summary.stateId : syntheticsStateId;
      }
    }
    const context = {
      ...alertState,
      ...(monitorSummary ? monitorSummary : {}),
      locationId: locationIds.join(` ${AND_LABEL} `),
      idWithLocation: recoveredAlertId,
      lastErrorMessage,
      recoveryStatus,
      linkMessage,
      stateId: syntheticsStateId,
      ...(isUp ? {
        status: 'up'
      } : {}),
      ...(recoveryReason ? {
        [_action_variables.RECOVERY_REASON]: recoveryReason
      } : {}),
      ...(basePath && spaceId && alertUuid ? {
        [_action_variables.ALERT_DETAILS_URL]: (0, _common.getAlertDetailsUrl)(basePath, spaceId, alertUuid)
      } : {})
    };
    alertsClient.setAlertData({
      id: recoveredAlertId,
      context
    });
  }
};
exports.setRecoveredAlertsContext = setRecoveredAlertsContext;
const getDefaultLinkMessage = ({
  basePath,
  spaceId,
  syntheticsStateId,
  configId,
  locationId
}) => {
  if (basePath && spaceId && syntheticsStateId && configId && locationId) {
    const relativeViewInAppUrl = getRelativeViewInAppUrl({
      configId,
      locationId,
      stateId: syntheticsStateId
    });
    return getFullViewInAppMessage(basePath, spaceId, relativeViewInAppUrl);
  } else {
    return '';
  }
};
exports.getDefaultLinkMessage = getDefaultLinkMessage;
const getDefaultRecoveredSummary = ({
  recoveredAlert,
  tz,
  dateFormat,
  params
}) => {
  if (!recoveredAlert.hit) return; // TODO: handle this case
  const hit = recoveredAlert.hit;
  const locationId = hit['location.id'];
  const configId = hit.configId;
  return (0, _message_utils.getMonitorSummary)({
    monitorInfo: {
      monitor: {
        id: hit['monitor.id'],
        name: hit['monitor.name'],
        type: hit['monitor.type']
      },
      service: {
        name: hit['service.name']
      },
      labels: hit.labels,
      config_id: configId,
      observer: {
        geo: {
          name: hit['observer.geo.name'] || hit['location.name']
        },
        name: locationId
      },
      agent: {
        name: hit['agent.name'] || ''
      },
      '@timestamp': String(hit['@timestamp']),
      ...(hit['error.message'] ? {
        error: {
          message: hit['error.message']
        }
      } : {}),
      ...(hit['url.full'] ? {
        url: {
          full: hit['url.full']
        }
      } : {})
    },
    reason: 'recovered',
    locationId,
    configId,
    dateFormat,
    tz,
    params
  });
};
exports.getDefaultRecoveredSummary = getDefaultRecoveredSummary;
const getDeletedMonitorOrLocationSummary = ({
  staleConfigs,
  recoveredAlertId,
  locationIds,
  dateFormat,
  tz,
  params
}) => {
  const config = staleConfigs[recoveredAlertId];
  const monitorInfo = 'monitorInfo' in config ? config.monitorInfo : config.latestPing;
  const monitorSummary = (0, _message_utils.getMonitorSummary)({
    monitorInfo,
    reason: 'recovered',
    locationId: locationIds,
    configId: config.configId,
    dateFormat,
    tz,
    params
  });
  const lastErrorMessage = monitorSummary.lastErrorMessage;
  if (config.isDeleted) {
    var _monitorInfo$state;
    return {
      lastErrorMessage,
      monitorSummary,
      stateId: monitorInfo === null || monitorInfo === void 0 ? void 0 : (_monitorInfo$state = monitorInfo.state) === null || _monitorInfo$state === void 0 ? void 0 : _monitorInfo$state.id,
      recoveryStatus: _i18n.i18n.translate('xpack.synthetics.alerts.monitorStatus.deleteMonitor.status', {
        defaultMessage: `has been deleted`
      }),
      recoveryReason: _i18n.i18n.translate('xpack.synthetics.alerts.monitorStatus.deleteMonitor.status', {
        defaultMessage: `has been deleted`
      })
    };
  } else if (config.isLocationRemoved) {
    var _monitorInfo$state2;
    return {
      monitorSummary,
      lastErrorMessage,
      stateId: monitorInfo === null || monitorInfo === void 0 ? void 0 : (_monitorInfo$state2 = monitorInfo.state) === null || _monitorInfo$state2 === void 0 ? void 0 : _monitorInfo$state2.id,
      recoveryStatus: _i18n.i18n.translate('xpack.synthetics.alerts.monitorStatus.removedLocation.status', {
        defaultMessage: `has recovered`
      }),
      recoveryReason: _i18n.i18n.translate('xpack.synthetics.alerts.monitorStatus.removedLocation.reason', {
        defaultMessage: `this location has been removed from the monitor`
      })
    };
  }
};
exports.getDeletedMonitorOrLocationSummary = getDeletedMonitorOrLocationSummary;
const getUpMonitorRecoverySummary = ({
  upConfigs,
  recoveredAlertId,
  alertHit,
  locationIds,
  configId,
  basePath,
  spaceId,
  dateFormat,
  tz,
  params
}) => {
  var _ping$state, _ping$state$ends;
  // pull the last error from state, since it is not available on the up ping
  const lastErrorMessage = alertHit === null || alertHit === void 0 ? void 0 : alertHit['error.message'];
  let linkMessage = '';
  const upConfig = upConfigs[recoveredAlertId];
  const isUp = Boolean(upConfig) || false;
  const ping = upConfig.latestPing;
  const monitorSummary = (0, _message_utils.getMonitorSummary)({
    monitorInfo: ping,
    reason: 'recovered',
    locationId: locationIds,
    configId,
    dateFormat,
    tz,
    params
  });

  // When alert is flapping, the stateId is not available on ping.state.ends.id, use state instead
  const stateId = (_ping$state = ping.state) === null || _ping$state === void 0 ? void 0 : (_ping$state$ends = _ping$state.ends) === null || _ping$state$ends === void 0 ? void 0 : _ping$state$ends.id;
  const upTimestamp = ping['@timestamp'];
  const checkedAt = (0, _moment.default)(upTimestamp).tz(tz).format(dateFormat);
  const recoveryStatus = _i18n.i18n.translate('xpack.synthetics.alerts.monitorStatus.upCheck.status', {
    defaultMessage: `is now up`
  });
  const recoveryReason = _i18n.i18n.translate('xpack.synthetics.alerts.monitorStatus.upCheck.reasonWithoutDuration', {
    defaultMessage: `the monitor is now up again. It ran successfully at {checkedAt}`,
    values: {
      checkedAt
    }
  });
  if (basePath && spaceId && stateId) {
    const relativeViewInAppUrl = getRelativeViewInAppUrl({
      configId,
      locationId: locationIds[0],
      stateId
    });
    linkMessage = getFullViewInAppMessage(basePath, spaceId, relativeViewInAppUrl);
  }
  return {
    monitorSummary,
    lastErrorMessage,
    recoveryStatus,
    recoveryReason,
    isUp,
    linkMessage,
    stateId
  };
};
exports.getUpMonitorRecoverySummary = getUpMonitorRecoverySummary;
const formatFilterString = async (syntheticsEsClient, filters, search) => await generateFilterDSL(() => (0, _get_index_pattern.getUptimeIndexPattern)({
  syntheticsEsClient
}), filters, search);
exports.formatFilterString = formatFilterString;
const hasFilters = filters => {
  if (!filters) return false;
  for (const list of Object.values(filters)) {
    if (list.length > 0) {
      return true;
    }
  }
  return false;
};
exports.hasFilters = hasFilters;
const generateFilterDSL = async (getIndexPattern, filters, search) => {
  const filtersExist = hasFilters(filters);
  if (!filtersExist && !search) return undefined;
  let filterString = '';
  if (filtersExist) {
    filterString = (0, _lib.stringifyKueries)(new Map(Object.entries(filters !== null && filters !== void 0 ? filters : {})));
  }
  const combinedString = (0, _lib.combineFiltersAndUserSearch)(filterString, search);
  return (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(combinedString !== null && combinedString !== void 0 ? combinedString : ''), await getIndexPattern());
};
exports.generateFilterDSL = generateFilterDSL;
const syntheticsRuleTypeFieldMap = exports.syntheticsRuleTypeFieldMap = {
  ..._synthetics_rule_field_map.syntheticsRuleFieldMap,
  ..._alertsAsDataUtils.legacyExperimentalFieldMap
};
const SyntheticsRuleTypeAlertDefinition = exports.SyntheticsRuleTypeAlertDefinition = {
  context: _synthetics_alerts.SYNTHETICS_RULE_TYPES_ALERT_CONTEXT,
  mappings: {
    fieldMap: syntheticsRuleTypeFieldMap
  },
  useLegacyAlerts: true,
  shouldWrite: true
};
function getTimeUnitLabel(timeWindow) {
  const {
    size: timeValue = 1,
    unit: timeUnit
  } = timeWindow;
  switch (timeUnit) {
    case 's':
      return _i18n.i18n.translate('xpack.synthetics.timeUnits.secondLabel', {
        defaultMessage: '{timeValue, plural, one {second} other {seconds}}',
        values: {
          timeValue
        }
      });
    case 'm':
      return _i18n.i18n.translate('xpack.synthetics.timeUnits.minuteLabel', {
        defaultMessage: '{timeValue, plural, one {minute} other {minutes}}',
        values: {
          timeValue
        }
      });
    case 'h':
      return _i18n.i18n.translate('xpack.synthetics.timeUnits.hourLabel', {
        defaultMessage: '{timeValue, plural, one {hour} other {hours}}',
        values: {
          timeValue
        }
      });
    case 'd':
      return _i18n.i18n.translate('xpack.synthetics.timeUnits.dayLabel', {
        defaultMessage: '{timeValue, plural, one {day} other {days}}',
        values: {
          timeValue
        }
      });
  }
}
const AND_LABEL = exports.AND_LABEL = _i18n.i18n.translate('xpack.synthetics.alerts.monitorStatus.andLabel', {
  defaultMessage: 'and'
});