"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = MonitorStatusAlert;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _reactQuery = require("@kbn/react-query");
var _public = require("@kbn/observability-shared-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _status_rule_ui = require("../../../components/alerts/status_rule_ui");
var _kibana_service = require("../../../../../utils/kibana_service");
var _state = require("../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-default-export
function MonitorStatusAlert({
  coreStart,
  plugins,
  params
}) {
  _kibana_service.kibanaService.coreStart = coreStart;
  const queryClient = new _reactQuery.QueryClient();
  const {
    ruleParams
  } = params;
  return /*#__PURE__*/_react.default.createElement(_public.InspectorContextProvider, null, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: _state.store
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: {
      ...coreStart,
      ...plugins
    }
  }, params.id && (0, _lodash.isEmpty)(ruleParams) && /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.alertRule.monitorStatus.description",
    defaultMessage: "Manage synthetics monitor status rule actions."
  })), (!params.id || !(0, _lodash.isEmpty)(ruleParams)) && /*#__PURE__*/_react.default.createElement(_status_rule_ui.StatusRuleComponent, {
    ruleParams: ruleParams,
    setRuleParams: params.setRuleParams
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })))));
}
module.exports = exports.default;