"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLocations = useLocations;
var _react = require("react");
var _reactRedux = require("react-redux");
var _state = require("../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useLocations() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    error,
    loading,
    locations,
    throttling,
    locationsLoaded
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  (0, _react.useEffect)(() => {
    if (!locationsLoaded) {
      dispatch((0, _state.getServiceLocations)());
    }
  }, [dispatch, locations, locationsLoaded]);
  const getLocationByLabel = label => {
    return locations.find(location => location.label === label);
  };
  return {
    error,
    loading,
    locations,
    throttling,
    getLocationByLabel
  };
}